/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.type;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.VeilTextResource;
import foundry.veil.impl.resource.action.FramebufferEditAction;
import foundry.veil.impl.resource.action.TextEditAction;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record FramebufferResource(VeilResourceInfo resourceInfo) implements VeilTextResource<FramebufferResource>
{
    @Override
    public List<VeilResourceAction<FramebufferResource>> getActions() {
        return List.of(new TextEditAction(), FramebufferEditAction.INSTANCE);
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) throws IOException {
        try (BufferedReader reader = this.resourceInfo.openAsReader(resourceManager);){
            DataResult result = FramebufferDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader));
            if (result.error().isPresent()) {
                throw new JsonParseException(((DataResult.Error)result.error().get()).message());
            }
            VeilRenderSystem.renderer().getFramebufferManager().setDefinition(FramebufferManager.FRAMEBUFFER_LISTER.method_45115(this.resourceInfo.location()), (FramebufferDefinition)result.getOrThrow());
        }
    }

    @Override
    public int getIconCode() {
        return 60687;
    }

    @Override
    @Nullable
    public TextEditorLanguageDefinition languageDefinition() {
        return null;
    }
}

