/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.RenderStyle;
import foundry.veil.api.quasar.particle.SpriteData;
import foundry.veil.api.quasar.registry.RenderStyleRegistry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record QuasarParticleData(boolean shouldCollide, boolean faceVelocity, float velocityStretchFactor, List<class_6880<ParticleModuleData>> initModules, List<class_6880<ParticleModuleData>> updateModules, List<class_6880<ParticleModuleData>> collisionModules, List<class_6880<ParticleModuleData>> forceModules, List<class_6880<ParticleModuleData>> renderModules, @Nullable SpriteData spriteData, boolean additive, RenderStyle renderStyle) {
    public static final Codec<QuasarParticleData> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("should_collide", (Object)true).forGetter(QuasarParticleData::shouldCollide), (App)Codec.BOOL.optionalFieldOf("face_velocity", (Object)false).forGetter(QuasarParticleData::faceVelocity), (App)Codec.FLOAT.optionalFieldOf("velocity_stretch_factor", (Object)Float.valueOf(0.0f)).forGetter(QuasarParticleData::velocityStretchFactor), (App)ParticleModuleData.INIT_CODEC.listOf().optionalFieldOf("init_modules", Collections.emptyList()).forGetter(QuasarParticleData::initModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("update_modules", Collections.emptyList()).forGetter(QuasarParticleData::updateModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("collision_modules", Collections.emptyList()).forGetter(QuasarParticleData::collisionModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("forces", Collections.emptyList()).forGetter(QuasarParticleData::forceModules), (App)ParticleModuleData.RENDER_CODEC.listOf().optionalFieldOf("render_modules", Collections.emptyList()).forGetter(QuasarParticleData::renderModules), (App)SpriteData.CODEC.optionalFieldOf("sprite_data").forGetter(data -> Optional.ofNullable(data.spriteData())), (App)Codec.BOOL.optionalFieldOf("additive", (Object)false).forGetter(QuasarParticleData::additive), (App)RenderStyle.CODEC.optionalFieldOf("render_style").forGetter(particleData -> Optional.of(particleData.renderStyle()))).apply((Applicative)instance, (shouldCollide, faceVelocity, velocityStretchFactor, initModules, updateModules, collisionModules, forceModules, renderModules, spriteData, additive, renderStyle) -> new QuasarParticleData((boolean)shouldCollide, (boolean)faceVelocity, velocityStretchFactor.floatValue(), (List<class_6880<ParticleModuleData>>)initModules, (List<class_6880<ParticleModuleData>>)updateModules, (List<class_6880<ParticleModuleData>>)collisionModules, (List<class_6880<ParticleModuleData>>)forceModules, (List<class_6880<ParticleModuleData>>)renderModules, spriteData.orElse(null), (boolean)additive, renderStyle.orElseGet(RenderStyleRegistry.BILLBOARD))));
    public static final Codec<class_6880<QuasarParticleData>> CODEC = class_5381.method_29749(QuasarParticles.PARTICLE_DATA, DIRECT_CODEC);

    public QuasarParticleData(boolean shouldCollide, boolean faceVelocity, float velocityStretchFactor, List<class_6880<ParticleModuleData>> initModules, List<class_6880<ParticleModuleData>> updateModules, List<class_6880<ParticleModuleData>> collisionModules, List<class_6880<ParticleModuleData>> forceModules, List<class_6880<ParticleModuleData>> renderModules, @Nullable SpriteData spriteData, boolean additive, RenderStyle renderStyle) {
        this.shouldCollide = shouldCollide;
        this.faceVelocity = faceVelocity;
        this.velocityStretchFactor = velocityStretchFactor;
        this.initModules = Collections.unmodifiableList(initModules);
        this.updateModules = Collections.unmodifiableList(updateModules);
        this.collisionModules = Collections.unmodifiableList(collisionModules);
        this.forceModules = Collections.unmodifiableList(forceModules);
        this.renderModules = Collections.unmodifiableList(renderModules);
        this.spriteData = spriteData;
        this.additive = additive;
        this.renderStyle = renderStyle;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public Stream<class_6880<ParticleModuleData>> allModules() {
        return this.getAllModules().stream();
    }

    public List<class_6880<ParticleModuleData>> getAllModules() {
        LinkedList<class_6880<ParticleModuleData>> builder = new LinkedList<class_6880<ParticleModuleData>>();
        builder.addAll(this.initModules);
        builder.addAll(this.updateModules);
        builder.addAll(this.collisionModules);
        builder.addAll(this.forceModules);
        builder.addAll(this.renderModules);
        return builder;
    }

    @Nullable
    public class_2960 getRegistryId() {
        return QuasarParticles.registryAccess().method_33310(QuasarParticles.PARTICLE_DATA).map(registry -> registry.method_10221((Object)this)).orElse(null);
    }
}

