/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;

public final class ScissorStack {
    private final Deque<ScissorRegion> regions = new ArrayDeque<ScissorRegion>();

    public void push(int x, int y, int width, int height) {
        if (!this.regions.isEmpty()) {
            ScissorRegion parent = this.regions.peek();
            int x2 = x + width;
            x = class_3532.method_15340((int)x, (int)parent.x, (int)(parent.x + parent.width));
            width = class_3532.method_15340((int)x2, (int)parent.x, (int)(parent.x + parent.width)) - x;
            int y2 = y + height;
            y = class_3532.method_15340((int)y, (int)parent.y, (int)(parent.y + parent.height));
            height = class_3532.method_15340((int)y2, (int)parent.y, (int)(parent.y + parent.height)) - y;
        }
        ScissorRegion region = new ScissorRegion(x, y, width, height);
        this.regions.push(region);
        region.apply();
    }

    public void pop() {
        this.regions.pop();
        if (this.regions.isEmpty()) {
            RenderSystem.disableScissor();
        } else {
            this.regions.peek().apply();
        }
    }

    public int size() {
        return this.regions.size();
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public void clear() {
        this.regions.clear();
        RenderSystem.disableScissor();
    }

    @ApiStatus.Internal
    private record ScissorRegion(int x, int y, int width, int height) {
        void apply() {
            double scale = class_310.method_1551().method_22683().method_4495();
            int screenY = (int)((double)(class_310.method_1551().method_22683().method_4506() - (this.y + this.height)) * scale);
            RenderSystem.enableScissor((int)((int)((double)this.x * scale)), (int)screenY, (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        }
    }
}

