/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class DebugRenderHelper {
    private DebugRenderHelper() {
    }

    public static void renderCube(class_4587 pPoseStack, class_4588 pConsumer, float pRed, float pGreen, float pBlue, float pAlpha) {
        DebugRenderHelper.renderBox(pPoseStack, pConsumer, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, pRed, pGreen, pBlue, pAlpha);
    }

    public static void renderBox(class_4587 pPoseStack, class_4588 pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        class_4587.class_4665 pose = pPoseStack.method_23760();
        float iX = (float)pMinX;
        float iY = (float)pMinY;
        float iZ = (float)pMinZ;
        float aX = (float)pMaxX;
        float aY = (float)pMaxY;
        float aZ = (float)pMaxZ;
        pConsumer.method_56824(pose, iX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, aX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, iX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, iX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, iX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
        pConsumer.method_56824(pose, iX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
        pConsumer.method_56824(pose, aX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, aX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, aX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, -1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, iX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, -1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, iX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
        pConsumer.method_56824(pose, iX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
        pConsumer.method_56824(pose, iX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, -1.0f, 0.0f);
        pConsumer.method_56824(pose, iX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, -1.0f, 0.0f);
        pConsumer.method_56824(pose, iX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, aX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, aX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, -1.0f);
        pConsumer.method_56824(pose, aX, iY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, -1.0f);
        pConsumer.method_56824(pose, iX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, aX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 1.0f, 0.0f, 0.0f);
        pConsumer.method_56824(pose, aX, iY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, aX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pConsumer.method_56824(pose, aX, aY, iZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
        pConsumer.method_56824(pose, aX, aY, aZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void renderBox(class_4587 pPoseStack, class_4588 pConsumer, class_238 box, float pRed, float pGreen, float pBlue, float pAlpha) {
        DebugRenderHelper.renderBox(pPoseStack, pConsumer, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, pRed, pGreen, pBlue, pAlpha);
    }

    public static void renderSphere(class_4587 pPoseStack, class_4588 pConsumer, int resolution, float radius, double x, double y, double z, float pRed, float pGreen, float pBlue, float pAlpha) {
        pPoseStack.method_22903();
        pPoseStack.method_22904(x, y, z);
        for (int i = 0; i < 3; ++i) {
            pPoseStack.method_22903();
            switch (i) {
                case 1: {
                    pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    break;
                }
                case 2: {
                    pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                }
            }
            class_4587.class_4665 pose = pPoseStack.method_23760();
            pPoseStack.method_22909();
            for (int segment = 0; segment < resolution; ++segment) {
                float angle1 = (float)segment / (float)resolution * ((float)Math.PI * 2);
                float angle2 = (float)(segment + 1) / (float)resolution * ((float)Math.PI * 2);
                float s1 = class_3532.method_15374((float)angle1) * radius;
                float c1 = class_3532.method_15362((float)angle1) * radius;
                float s2 = class_3532.method_15374((float)angle2) * radius;
                float c2 = class_3532.method_15362((float)angle2) * radius;
                Vector3f normal = new Vector3f(s1, 0.0f, c1);
                normal.sub((Vector3fc)new Vector3f(s2, 0.0f, c2));
                normal.normalize();
                DebugRenderHelper.renderLine(pose, pConsumer, s1, c1, 0.0f, s2, c2, 0.0f, pRed, pGreen, pBlue, pAlpha);
            }
        }
        pPoseStack.method_22909();
    }

    public static void renderCircle(class_4587 pPoseStack, class_4588 pConsumer, int resolution, float radius, double x, double y, double z, float pRed, float pGreen, float pBlue, float pAlpha) {
        class_310 mc = class_310.method_1551();
        class_4184 pRenderInfo = mc.field_1773.method_19418();
        Quaternionf rotation = pRenderInfo.method_23767();
        pPoseStack.method_22903();
        pPoseStack.method_22904(x, y, z);
        pPoseStack.method_22907(rotation);
        class_4587.class_4665 pose = pPoseStack.method_23760();
        for (int segment = 0; segment < resolution; ++segment) {
            float angle1 = (float)segment / (float)resolution * ((float)Math.PI * 2);
            float angle2 = (float)(segment + 1) / (float)resolution * ((float)Math.PI * 2);
            float s1 = class_3532.method_15374((float)angle1) * radius;
            float c1 = class_3532.method_15362((float)angle1) * radius;
            float s2 = class_3532.method_15374((float)angle2) * radius;
            float c2 = class_3532.method_15362((float)angle2) * radius;
            Vector3f normal = new Vector3f(s1, 0.0f, c1);
            normal.sub((Vector3fc)new Vector3f(s2, 0.0f, c2));
            normal.normalize();
            DebugRenderHelper.renderLine(pose, pConsumer, s1, c1, 0.0f, s2, c2, 0.0f, pRed, pGreen, pBlue, pAlpha);
        }
        pPoseStack.method_22909();
    }

    public static void renderLine(class_4587 pPoseStack, class_4588 pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        class_4587.class_4665 pose = pPoseStack.method_23760();
        float minX = (float)pMinX;
        float minY = (float)pMinY;
        float minZ = (float)pMinZ;
        float maxX = (float)pMaxX;
        float maxY = (float)pMaxY;
        float maxZ = (float)pMaxZ;
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.method_56824(pose, minX, minY, minZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, normal.x(), normal.y(), normal.z());
        pConsumer.method_56824(pose, maxX, maxY, maxZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, normal.x(), normal.y(), normal.z());
    }

    public static void renderLine(class_4587 pPoseStack, class_4588 pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        class_4587.class_4665 pose = pPoseStack.method_23760();
        float minX = (float)pMinX;
        float minY = (float)pMinY;
        float minZ = (float)pMinZ;
        float maxX = (float)pMaxX;
        float maxY = (float)pMaxY;
        float maxZ = (float)pMaxZ;
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.method_56824(pose, minX, minY, minZ).method_22915(r1, g1, b1, a1).method_60831(pose, normal.x(), normal.y(), normal.z());
        pConsumer.method_56824(pose, maxX, maxY, maxZ).method_22915(r2, g2, b2, a2).method_60831(pose, normal.x(), normal.y(), normal.z());
    }

    public static void renderLine(class_4587.class_4665 pose, class_4588 pConsumer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.method_56824(pose, minX, minY, minZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, normal.x(), normal.y(), normal.z());
        pConsumer.method_56824(pose, maxX, maxY, maxZ).method_22915(pRed, pGreen, pBlue, pAlpha).method_60831(pose, normal.x(), normal.y(), normal.z());
    }
}

