/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL12C;

public abstract class ArrayTexture
extends class_1044 {
    private int width;
    private int height;

    protected void init(int format, int mipmapLevel, int width, int height, int depth) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.method_23207();
        if (mipmapLevel >= 0) {
            GlStateManager._texParameter((int)35866, (int)33085, (int)mipmapLevel);
            GlStateManager._texParameter((int)35866, (int)33082, (int)0);
            GlStateManager._texParameter((int)35866, (int)33083, (int)mipmapLevel);
            GlStateManager._texParameter((int)35866, (int)34049, (float)0.0f);
        }
        this.width = width;
        this.height = height;
        for (int i = 0; i <= mipmapLevel; ++i) {
            GL12C.glTexImage3D((int)35866, (int)i, (int)format, (int)(width >> i), (int)(height >> i), (int)depth, (int)0, (int)6408, (int)5121, (long)0L);
        }
    }

    protected void upload(class_1011 ... images) {
        this.method_23207();
        for (int i = 0; i < images.length; ++i) {
            class_1011 image = images[i];
            if (image.method_4307() != this.width || image.method_4323() != this.height) {
                throw new IllegalArgumentException("Image dimensions don't match");
            }
            GL12C.glTexSubImage3D((int)35866, (int)0, (int)0, (int)0, (int)i, (int)image.method_4307(), (int)image.method_4323(), (int)1, (int)image.method_4318().method_4333(), (int)5121, (long)((PipelineNativeImageAccessor)image).getPixels());
        }
    }

    public void method_4527(boolean blur, boolean mipmap) {
        int magFilter;
        int minFilter;
        RenderSystem.assertOnRenderThreadOrInit();
        this.field_5205 = blur;
        this.field_5203 = mipmap;
        if (blur) {
            minFilter = mipmap ? 9987 : 9729;
            magFilter = 9729;
        } else {
            minFilter = mipmap ? 9986 : 9728;
            magFilter = 9728;
        }
        if (VeilRenderSystem.directStateAccessSupported()) {
            int id = this.method_4624();
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10241, (int)minFilter);
            ARBDirectStateAccess.glTextureParameteri((int)id, (int)10240, (int)magFilter);
        } else {
            this.method_23207();
            GL12C.glTexParameteri((int)35866, (int)10241, (int)minFilter);
            GL12C.glTexParameteri((int)35866, (int)10240, (int)magFilter);
        }
    }

    public int method_4624() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.field_5204 == -1) {
            this.field_5204 = VeilRenderSystem.createTextures(35866);
        }
        return this.field_5204;
    }

    public void method_23207() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> GL12C.glBindTexture((int)35866, (int)this.method_4624()));
    }
}

