/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.pipeline.client;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.RenderTargetExtension;
import net.minecraft.class_276;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_276.class})
public abstract class PipelineRenderTargetMixin
implements RenderTargetExtension {
    @Shadow
    public int field_1476;
    @Shadow
    public int field_1482;
    @Shadow
    public int field_1481;
    @Shadow
    public int field_1480;
    @Shadow
    public int field_1477;
    @Unique
    private AdvancedFbo veil$wrapper;
    @Unique
    private int veil$vanillaFramebufferId;
    @Unique
    private int veil$vanillaWidth;
    @Unique
    private int veil$vanillaHeight;
    @Unique
    private int veil$vanillaViewWidth;
    @Unique
    private int veil$vanillaViewHeight;

    @Unique
    private void veil$saveState() {
        this.veil$vanillaFramebufferId = this.field_1476;
        this.veil$vanillaWidth = this.field_1482;
        this.veil$vanillaHeight = this.field_1481;
        this.veil$vanillaViewWidth = this.field_1480;
        this.veil$vanillaViewHeight = this.field_1477;
    }

    @Unique
    private void veil$loadState() {
        this.field_1476 = this.veil$vanillaFramebufferId;
        this.field_1482 = this.veil$vanillaWidth;
        this.field_1481 = this.veil$vanillaHeight;
        this.field_1480 = this.veil$vanillaViewWidth;
        this.field_1477 = this.veil$vanillaViewHeight;
    }

    @Inject(method={"destroyBuffers"}, at={@At(value="HEAD")})
    public void destroyBuffers(CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            this.veil$loadState();
        }
    }

    @Inject(method={"createBuffers"}, at={@At(value="RETURN")})
    public void createBuffers(CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            this.veil$saveState();
            this.field_1476 = this.veil$wrapper.getId();
            this.field_1482 = this.veil$wrapper.getWidth();
            this.field_1481 = this.veil$wrapper.getHeight();
            this.field_1480 = this.field_1482;
            this.field_1477 = this.field_1481;
        }
    }

    @Override
    public void veil$setWrapper(@Nullable AdvancedFbo fbo) {
        if (this.veil$wrapper == null ^ fbo == null) {
            if (fbo != null) {
                this.veil$saveState();
                this.field_1476 = fbo.getId();
                this.field_1482 = fbo.getWidth();
                this.field_1481 = fbo.getHeight();
                this.field_1480 = this.field_1482;
                this.field_1477 = this.field_1481;
            } else {
                this.veil$loadState();
            }
        }
        this.veil$wrapper = fbo;
    }

    @Override
    public int veil$getTexture(int buffer) {
        if (this.veil$wrapper != null && this.veil$wrapper.isColorTextureAttachment(buffer)) {
            return this.veil$wrapper.getColorTextureAttachment(buffer).method_4624();
        }
        return 0;
    }

    @Inject(method={"bindRead"}, at={@At(value="HEAD")}, cancellable=true)
    public void bindRead(CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            if (this.veil$wrapper.isColorTextureAttachment(0)) {
                this.veil$wrapper.getColorTextureAttachment(0).method_23207();
            } else {
                GlStateManager._bindTexture((int)0);
            }
            ci.cancel();
        }
    }

    @Inject(method={"bindWrite"}, at={@At(value="HEAD")}, cancellable=true)
    public void bindWrite(boolean setViewport, CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            this.veil$wrapper.bind(setViewport);
            ci.cancel();
        }
    }

    @Inject(method={"getColorTextureId"}, at={@At(value="HEAD")}, cancellable=true)
    public void getColorTextureId(CallbackInfoReturnable<Integer> cir) {
        if (this.veil$wrapper != null) {
            cir.setReturnValue((Object)this.veil$wrapper.getColorTextureAttachment(0).method_4624());
        }
    }

    @Inject(method={"getDepthTextureId"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDepthTextureId(CallbackInfoReturnable<Integer> cir) {
        if (this.veil$wrapper != null) {
            cir.setReturnValue((Object)this.veil$wrapper.getDepthTextureAttachment().method_4624());
        }
    }
}

