/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.dynamicbuffer.client;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import foundry.veil.mixin.dynamicbuffer.accessor.DynamicBufferProgramAccessor;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3679;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5944.class})
public abstract class DynamicBufferShaderInstanceMixin
implements class_3679,
ShaderInstanceExtension {
    @Mutable
    @Shadow
    @Final
    private class_281 field_29467;
    @Mutable
    @Shadow
    @Final
    private class_281 field_29468;
    @Mutable
    @Shadow
    @Final
    private int field_29493;
    @Shadow
    @Final
    private class_293 field_29469;
    @Shadow
    @Final
    public Map<String, class_284> field_29492;
    @Shadow
    @Final
    private List<Integer> field_29491;
    @Shadow
    @Final
    private List<Integer> field_29489;
    @Shadow
    @Final
    private String field_29494;
    @Shadow
    @Final
    private List<class_284> field_29490;
    @Unique
    private String veil$vertexSource;
    @Unique
    private String veil$fragmentSource;
    @Unique
    private int veil$activeBuffers;
    @Unique
    private final Int2IntMap veil$programCache = new Int2IntArrayMap(1);

    @Shadow
    protected abstract void method_34588();

    @Shadow
    public abstract void method_34418();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.veil$programCache.put(0, this.field_29493);
        if (this instanceof ShaderProgramImpl.Wrapper) {
            return;
        }
        VeilDebug debug = VeilDebug.get();
        debug.objectLabel(33506, this.field_29493, "Vanilla Shader Program " + this.field_29494 + ":default");
        debug.objectLabel(33505, ((DynamicBufferProgramAccessor)this.field_29467).getId(), "Vanilla vertex Shader " + this.field_29467.method_1280() + ":default");
        debug.objectLabel(33505, ((DynamicBufferProgramAccessor)this.field_29468).getId(), "Vanilla fragment Shader " + this.field_29468.method_1280() + ":default");
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void apply(CallbackInfo ci) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderCompiler.markRendered(this.field_29494);
        this.veil$applyCompile();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.veil$programCache.isEmpty()) {
            return;
        }
        this.field_29493 = this.veil$programCache.remove(0);
        IntIterator intIterator = this.veil$programCache.values().iterator();
        while (intIterator.hasNext()) {
            int program = (Integer)intIterator.next();
            GL20C.glDeleteProgram((int)program);
        }
        this.veil$programCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void veil$applyCompile() {
        if (this.veil$vertexSource != null && this.veil$fragmentSource != null) {
            int oldProgram = this.field_29493;
            this.field_29493 = GL20C.glCreateProgram();
            int vertexShader = GL20C.glCreateShader((int)35633);
            int fragmentShader = GL20C.glCreateShader((int)35632);
            try {
                GlStateManager.glShaderSource((int)vertexShader, List.of(this.veil$vertexSource));
                GL20C.glCompileShader((int)vertexShader);
                if (GL20C.glGetShaderi((int)vertexShader, (int)35713) != 1) {
                    String error = GL20C.glGetShaderInfoLog((int)vertexShader).trim();
                    throw new IOException("Couldn't compile dynamic vertex program (" + this.field_29467.method_1280() + ", " + this.field_29494 + ") : " + error);
                }
                GlStateManager.glShaderSource((int)fragmentShader, List.of(this.veil$fragmentSource));
                GL20C.glCompileShader((int)fragmentShader);
                if (GL20C.glGetShaderi((int)fragmentShader, (int)35713) != 1) {
                    String error = GL20C.glGetShaderInfoLog((int)fragmentShader).trim();
                    throw new IOException("Couldn't compile dynamic fragment program (" + this.field_29468.method_1280() + ", " + this.field_29494 + ") : " + error);
                }
                int index = 0;
                for (String name : this.field_29469.method_34445()) {
                    GL20C.glBindAttribLocation((int)this.field_29493, (int)index, (CharSequence)name);
                    ++index;
                }
                DynamicBufferProgramAccessor vertexAccessor = (DynamicBufferProgramAccessor)this.field_29467;
                DynamicBufferProgramAccessor fragmentAccessor = (DynamicBufferProgramAccessor)this.field_29468;
                int oldVertex = vertexAccessor.getId();
                int oldFragment = fragmentAccessor.getId();
                vertexAccessor.setId(vertexShader);
                fragmentAccessor.setId(fragmentShader);
                this.method_34418();
                vertexAccessor.setId(oldVertex);
                fragmentAccessor.setId(oldFragment);
                GL20C.glLinkProgram((int)this.field_29493);
                if (GL20C.glGetProgrami((int)this.field_29493, (int)35714) != 1) {
                    String error = GL20C.glGetProgramInfoLog((int)this.field_29493).trim();
                    throw new IOException("Couldn't link shader (" + this.field_29494 + ") : " + error);
                }
                this.veil$invalidate();
                int old = this.veil$programCache.put(this.veil$activeBuffers, this.field_29493);
                if (old != 0) {
                    GL20C.glDeleteProgram((int)old);
                }
                String type = this.veil$activeBuffers == 0 ? "default" : Integer.toString(this.veil$activeBuffers);
                VeilDebug debug = VeilDebug.get();
                debug.objectLabel(33506, this.field_29493, "Vanilla Shader Program " + this.field_29494 + ":" + type);
                debug.objectLabel(33505, vertexShader, "Vanilla vertex Shader " + this.field_29467.method_1280() + ":" + type);
                debug.objectLabel(33505, fragmentShader, "Vanilla fragment Shader " + this.field_29468.method_1280() + ":" + type);
            }
            catch (Throwable t) {
                this.veil$programCache.remove(this.veil$activeBuffers);
                GL20C.glDeleteProgram((int)this.field_29493);
                this.field_29493 = oldProgram;
                Veil.LOGGER.error("Failed to recompile vanilla shader: {}", (Object)this.field_29494, (Object)t);
            }
            finally {
                GL20C.glDeleteShader((int)vertexShader);
                GL20C.glDeleteShader((int)fragmentShader);
            }
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
    }

    @Unique
    private void veil$invalidate() {
        this.field_29489.clear();
        this.field_29491.clear();
        this.field_29492.clear();
        for (class_284 uniform : this.field_29490) {
            uniform.method_1297(-1);
        }
        this.method_34588();
        this.method_1279();
    }

    @Override
    public Collection<class_2960> veil$getShaderSources() {
        class_2960 vertexProgramName = class_2960.method_60654((String)this.field_29467.method_1280());
        class_2960 fragmentProgramName = class_2960.method_60654((String)this.field_29468.method_1280());
        class_2960 vertexPath = class_2960.method_60655((String)vertexProgramName.method_12836(), (String)("shaders/core/" + vertexProgramName.method_12832() + class_281.class_282.field_1530.method_1284()));
        class_2960 fragmentPath = class_2960.method_60655((String)fragmentProgramName.method_12836(), (String)("shaders/core/" + fragmentProgramName.method_12832() + class_281.class_282.field_1531.method_1284()));
        return List.of(vertexPath, fragmentPath);
    }

    @Override
    public boolean veil$swapBuffers(int activeBuffers) {
        if (this.veil$activeBuffers == activeBuffers) {
            return false;
        }
        this.veil$applyCompile();
        int programId = this.veil$programCache.get(activeBuffers);
        if (programId != 0) {
            this.veil$activeBuffers = activeBuffers;
            this.field_29493 = programId;
            this.veil$invalidate();
            return false;
        }
        return true;
    }

    @Override
    public void veil$recompile(boolean vertex, String source, int activeBuffers) {
        if (this.veil$activeBuffers != activeBuffers) {
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
        this.veil$activeBuffers = activeBuffers;
        if (vertex) {
            this.veil$vertexSource = source;
        } else {
            this.veil$fragmentSource = source;
        }
    }
}

