/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource.loader;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.VeilShaderDefinitionResource;
import foundry.veil.api.resource.type.VeilShaderFileResource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public class ShaderResourceLoader
implements VeilResourceLoader {
    private static final Set<String> EXTENSIONS = Set.of(".json", ".glsl", ".vsh", ".tcsh", ".tesh", ".gsh", ".fsh", ".comp");
    private final ShaderManager shaderManager;

    public ShaderResourceLoader(ShaderManager shaderManager) {
        this.shaderManager = shaderManager;
    }

    @Override
    public boolean canLoad(class_3264 packType, class_2960 location, Path filePath, @Nullable Path modResourcePath) {
        if (packType != class_3264.field_14188) {
            return false;
        }
        String path = location.method_12832();
        if (path.startsWith(this.shaderManager.getSourceSet().getFolder())) {
            for (String extension : EXTENSIONS) {
                if (!path.endsWith(extension)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public VeilResource<?> load(VeilResourceManager resourceManager, class_5912 provider, class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath) throws IOException {
        VeilResourceInfo info = new VeilResourceInfo(packType, location, filePath, modResourcePath, false);
        return location.method_12832().endsWith(".json") ? new VeilShaderDefinitionResource(info, this.shaderManager) : new VeilShaderFileResource(info, this.shaderManager);
    }
}

