/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.wrapper;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.impl.client.render.wrapper.VanillaAdvancedFboWrapper;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class DSAVanillaAdvancedFboWrapper
extends VanillaAdvancedFboWrapper {
    public DSAVanillaAdvancedFboWrapper(Supplier<class_276> renderTargetSupplier) {
        super(renderTargetSupplier);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha, int clearMask, int ... clearBuffers) {
        if (clearMask == 0) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            boolean clearTex = VeilRenderSystem.clearTextureSupported();
            class_276 renderTarget = this.toRenderTarget();
            if ((clearMask & 0x4000) != 0) {
                if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)renderTarget.method_30277(), (int)0, (int)6408, (int)5126, (FloatBuffer)stack.floats(red, green, blue, alpha));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)renderTarget.method_30277(), (int)6144, (int)0, (FloatBuffer)stack.floats(red, green, blue, alpha));
                }
            }
            if (renderTarget.field_1478) {
                boolean stencil;
                boolean hasStencil = this.hasStencilAttachment();
                boolean depth = (clearMask & 0x100) != 0;
                boolean bl = stencil = hasStencil && (clearMask & 0x400) != 0;
                if (!depth && !stencil) {
                    return;
                }
                if (hasStencil) {
                    if (depth && stencil) {
                        if (clearTex) {
                            ARBClearTexture.glClearTexImage((int)renderTarget.method_30278(), (int)0, (int)34041, (int)36269, (ByteBuffer)null);
                        } else {
                            ARBDirectStateAccess.glClearNamedFramebufferfi((int)this.getId(), (int)34041, (int)0, (float)1.0f, (int)0);
                        }
                    } else {
                        if (depth) {
                            ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.getId(), (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                        }
                        if (stencil) {
                            ARBDirectStateAccess.glClearNamedFramebufferiv((int)this.getId(), (int)6146, (int)0, (IntBuffer)stack.ints(0));
                        }
                    }
                } else if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)renderTarget.method_30278(), (int)0, (int)6402, (int)5126, (FloatBuffer)stack.floats(1.0f));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.getId(), (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                }
            }
        }
        if (class_310.field_1703) {
            GL30C.glGetError();
        }
    }

    @Override
    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)id, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
    }

    @Override
    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)target.getId(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.getWidth(), (int)target.getHeight(), (int)mask, (int)filtering);
    }

    @Override
    public void resolveToRenderTarget(class_276 target, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)target.field_1476, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.field_1482, (int)target.field_1481, (int)mask, (int)filtering);
    }
}

