/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.perspective;

import foundry.veil.impl.client.render.perspective.LevelPerspectiveCamera;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_5539;
import net.minecraft.class_769;
import net.minecraft.class_846;
import net.minecraft.class_8603;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VeilSectionOcclusionGraph {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final int MINIMUM_ADVANCED_CULLING_DISTANCE = 60;
    private static final double CEILED_SECTION_DIAGONAL = Math.ceil(Math.sqrt(3.0) * 16.0);
    private final NodeQueue nodeQueue = new NodeQueue(64);
    private class_769 viewArea;
    private int viewDistance;

    public void update(class_769 viewArea, boolean smartCull, LevelPerspectiveCamera camera, class_4604 frustum, List<class_846.class_851> sections) {
        this.viewArea = viewArea;
        this.viewDistance = Math.min(viewArea.method_52839(), class_3532.method_15386((float)camera.getRenderDistance()));
        GraphStorage graphState = new GraphStorage(viewArea.field_4150.length);
        this.initializeQueueForFullUpdate(camera, viewArea);
        this.nodeQueue.forEach((Consumer<? super Node>)((Consumer<Node>)node -> graphState.sectionToNodeMap.put(node.section, (Node)node)));
        this.runUpdates(graphState, viewArea, camera.method_19326(), frustum, this.nodeQueue, smartCull, sections);
    }

    public void reset() {
        this.nodeQueue.trim(64);
    }

    private void initializeQueueForFullUpdate(class_4184 camera, class_769 viewArea) {
        this.nodeQueue.clear();
        class_2338 pos = camera.method_19328();
        class_846.class_851 renderSection = viewArea.method_3323(pos);
        if (renderSection != null) {
            this.nodeQueue.add(new Node(renderSection, 0));
            return;
        }
        class_243 cameraPos = camera.method_19326();
        class_5539 level = viewArea.method_52840();
        boolean aboveVoid = pos.method_10264() > level.method_31607();
        int startY = aboveVoid ? level.method_31600() - 8 : level.method_31607() + 8;
        int startX = class_3532.method_15357((double)(cameraPos.field_1352 / 16.0)) << 4;
        int startZ = class_3532.method_15357((double)(cameraPos.field_1350 / 16.0)) << 4;
        int radius = this.viewDistance;
        ArrayList<Node> list = new ArrayList<Node>(4 * radius * radius);
        class_2338.class_2339 renderSectionPos = new class_2338.class_2339();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                class_846.class_851 section = viewArea.method_3323((class_2338)renderSectionPos.method_10103(startX + x << 12, startY, startZ + z << 12));
                if (section == null || !this.isInViewDistance(pos, section.method_3670())) continue;
                class_2350 direction = aboveVoid ? class_2350.field_11033 : class_2350.field_11036;
                Node node2 = new Node(section, 0);
                node2.addSourceDirection(direction);
                node2.addDirection(direction);
                if (x > 0) {
                    node2.addDirection(class_2350.field_11034);
                } else if (x < 0) {
                    node2.addDirection(class_2350.field_11039);
                }
                if (z > 0) {
                    node2.addDirection(class_2350.field_11035);
                } else if (z < 0) {
                    node2.addDirection(class_2350.field_11043);
                }
                list.add(node2);
            }
        }
        list.sort(Comparator.comparingDouble(node -> {
            class_2338 origin = node.section.method_3670();
            return pos.method_10268((double)origin.method_10263() + 8.5, (double)origin.method_10264() + 8.5, (double)origin.method_10260() + 8.5);
        }));
        this.nodeQueue.addAll((Collection<? extends Node>)list);
    }

    private void runUpdates(GraphStorage graphStorage, class_769 viewArea, class_243 cameraPosition, class_4604 frustum, Queue<Node> nodeQueue, boolean smartCull, List<class_846.class_851> sections) {
        class_2338 cameraSectionPos = new class_2338(class_3532.method_15357((double)(cameraPosition.field_1352 / 16.0)) << 4, class_3532.method_15357((double)(cameraPosition.field_1351 / 16.0)) << 4, class_3532.method_15357((double)(cameraPosition.field_1350 / 16.0)) << 4);
        class_2338 cameraCenter = cameraSectionPos.method_10069(8, 8, 8);
        class_2338.class_2339 temp = new class_2338.class_2339();
        class_5539 level = viewArea.method_52840();
        int maxBuildHeight = level.method_31600();
        int minBuildHeight = level.method_31607();
        while (!nodeQueue.isEmpty()) {
            class_2338 origin;
            Node node = nodeQueue.poll();
            class_846.class_851 renderSection = node.section;
            if (frustum.method_23093(renderSection.method_40051()) && graphStorage.renderSections.add(renderSection.field_29641)) {
                sections.add(node.section);
            }
            boolean far = Math.abs((origin = renderSection.method_3670()).method_10263() - cameraSectionPos.method_10263()) > 60 || Math.abs(origin.method_10264() - cameraSectionPos.method_10264()) > 60 || Math.abs(origin.method_10260() - cameraSectionPos.method_10260()) > 60;
            for (class_2350 direction : DIRECTIONS) {
                Node node2;
                class_846.class_851 section = this.getRelativeFrom(cameraSectionPos, renderSection, direction);
                if (section == null) continue;
                class_2350 opposite = direction.method_10153();
                if (smartCull && (node.directions & 1 << opposite.ordinal()) != 0) continue;
                if (smartCull && node.sourceDirections != 0) {
                    class_846.class_849 compiledSection = renderSection.method_3677();
                    boolean visible = false;
                    for (int i = 0; i < DIRECTIONS.length; ++i) {
                        if ((node.sourceDirections & 1 << i) == 0 || !compiledSection.method_3650(DIRECTIONS[i], opposite)) continue;
                        visible = true;
                        break;
                    }
                    if (!visible) continue;
                }
                class_2338 neighborOrigin = section.method_3670();
                if (smartCull && far) {
                    int offsetY;
                    int offsetX;
                    int n = (direction.method_10166() == class_2350.class_2351.field_11048 ? cameraCenter.method_10263() <= neighborOrigin.method_10263() : cameraCenter.method_10263() >= neighborOrigin.method_10263()) ? 0 : (offsetX = 16);
                    int n2 = (direction.method_10166() == class_2350.class_2351.field_11052 ? cameraCenter.method_10264() <= neighborOrigin.method_10264() : cameraCenter.method_10264() >= neighborOrigin.method_10264()) ? 0 : (offsetY = 16);
                    int offsetZ = (direction.method_10166() == class_2350.class_2351.field_11051 ? cameraCenter.method_10260() <= neighborOrigin.method_10260() : cameraCenter.method_10260() >= neighborOrigin.method_10260()) ? 0 : 16;
                    temp.method_25504((class_2382)neighborOrigin, offsetX, offsetY, offsetZ);
                    Vector3d pos = new Vector3d(cameraPosition.field_1352 - (double)temp.method_10263(), cameraPosition.field_1351 - (double)temp.method_10264(), cameraPosition.field_1350 - (double)temp.method_10260());
                    Vector3d step = pos.normalize(CEILED_SECTION_DIAGONAL, new Vector3d());
                    boolean visible = true;
                    while (pos.distanceSquared(cameraPosition.field_1352, cameraPosition.field_1351, cameraPosition.field_1350) > 3600.0) {
                        pos.add((Vector3dc)step);
                        if (pos.y > (double)maxBuildHeight || pos.y < (double)minBuildHeight) break;
                        class_846.class_851 renderSection3 = viewArea.method_3323((class_2338)temp.method_10102(Math.floor(pos.x), Math.floor(pos.y), Math.floor(pos.z)));
                        if (renderSection3 != null && graphStorage.sectionToNodeMap.get(renderSection3) != null) continue;
                        visible = false;
                        break;
                    }
                    if (!visible) continue;
                }
                if ((node2 = graphStorage.sectionToNodeMap.get(section)) != null) {
                    node2.addSourceDirection(direction);
                    continue;
                }
                Node node3 = new Node(section, node.step + 1);
                node3.addSourceDirection(direction);
                node3.addDirection(direction);
                if (section.method_3673()) {
                    nodeQueue.add(node3);
                    graphStorage.sectionToNodeMap.put(section, node3);
                    continue;
                }
                if (!this.isInViewDistance(cameraSectionPos, neighborOrigin)) continue;
                graphStorage.sectionToNodeMap.put(section, node3);
            }
        }
    }

    private boolean isInViewDistance(class_2338 pos, class_2338 origin) {
        int centerX = pos.method_10263() >> 4;
        int centerZ = pos.method_10260() >> 4;
        int x = origin.method_10263() >> 4;
        int z = origin.method_10260() >> 4;
        return class_8603.method_52358((int)centerX, (int)centerZ, (int)this.viewDistance, (int)x, (int)z, (boolean)false);
    }

    @Nullable
    private class_846.class_851 getRelativeFrom(class_2338 pos, class_846.class_851 section, class_2350 direction) {
        class_2338 origin = section.method_3676(direction);
        if (!this.isInViewDistance(pos, origin)) {
            return null;
        }
        return class_3532.method_15382((int)(pos.method_10264() - origin.method_10264())) > this.viewDistance << 4 ? null : this.viewArea.method_3323(origin);
    }

    private static class NodeQueue
    implements Queue<Node> {
        private Node[] data;
        private int size;
        private int readPointer;

        public NodeQueue(int initialCapacity) {
            this.data = new Node[initialCapacity];
            this.size = 0;
        }

        public void trim(int size) {
            if (this.data.length > size) {
                this.data = new Node[size];
            }
            this.size = 0;
            this.readPointer = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.readPointer >= this.size;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Iterator<Node> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Node node) {
            if (this.size >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.size++] = node;
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Node> c) {
            if (this.isEmpty() && c instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)c;
                this.data = (Node[])arrayList.toArray(Node[]::new);
                return true;
            }
            if (this.size + c.size() > this.data.length) {
                this.data = Arrays.copyOf(this.data, this.size + c.size());
            }
            for (Node node : c) {
                this.data[this.size++] = node;
            }
            return true;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.size = 0;
            this.readPointer = 0;
        }

        @Override
        public boolean offer(Node node) {
            return this.add(node);
        }

        @Override
        public Node remove() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public Node poll() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer++];
            }
            return null;
        }

        @Override
        public Node element() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer];
            }
            throw new NoSuchElementException();
        }

        @Override
        public Node peek() {
            return this.readPointer >= this.size ? null : this.data[this.readPointer];
        }

        @Override
        public void forEach(Consumer<? super Node> action) {
            for (int i = this.readPointer; i < this.size; ++i) {
                action.accept(this.data[i]);
            }
        }
    }

    private static class GraphStorage {
        public final SectionToNodeMap sectionToNodeMap;
        public final IntSet renderSections;

        public GraphStorage(int size) {
            this.sectionToNodeMap = new SectionToNodeMap(size);
            this.renderSections = new IntArraySet(size);
        }
    }

    private static class Node {
        private final class_846.class_851 section;
        private int sourceDirections;
        private int directions;
        private final int step;

        private Node(class_846.class_851 section, int step) {
            this.section = section;
            this.step = step;
        }

        private void addDirection(class_2350 direction) {
            this.directions |= 1 << direction.ordinal();
        }

        private void addSourceDirection(class_2350 sourceDirection) {
            this.sourceDirections |= 1 << sourceDirection.ordinal();
        }

        public int hashCode() {
            return this.section.method_3670().hashCode();
        }

        public boolean equals(Object object) {
            return this.section.method_3670().equals((Object)((Node)object).section.method_3670());
        }
    }

    private static class SectionToNodeMap {
        private final Node[] nodes;

        private SectionToNodeMap(int size) {
            this.nodes = new Node[size];
        }

        public void put(class_846.class_851 section, Node node) {
            this.nodes[section.field_29641] = node;
        }

        @Nullable
        public Node get(class_846.class_851 section) {
            int index = section.field_29641;
            return index >= 0 && index < this.nodes.length ? this.nodes[index] : null;
        }
    }
}

