/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.framebuffer;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30C;

@ApiStatus.Internal
public abstract class AdvancedFboImpl
implements AdvancedFbo {
    protected static final Map<Integer, String> ERRORS = Map.of(36054, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT", 36055, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", 36059, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER", 36060, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER", 36061, "GL_FRAMEBUFFER_UNSUPPORTED", 36182, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", 33305, "GL_FRAMEBUFFER_UNDEFINED", 1285, "GL_OUT_OF_MEMORY");
    public static final Supplier<AdvancedFbo> MAIN_WRAPPER = Suppliers.memoize(() -> VeilRenderBridge.wrap(() -> ((class_310)class_310.method_1551()).method_1522()));
    protected int id = -1;
    protected final int width;
    protected final int height;
    protected final AdvancedFboAttachment[] colorAttachments;
    protected final AdvancedFboAttachment depthAttachment;
    protected final boolean hasStencil;
    protected final String debugLabel;
    protected final int clearMask;
    protected final int[] drawBuffers;
    protected int[] currentDrawBuffers;
    protected final Supplier<Wrapper> wrapper;

    public AdvancedFboImpl(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment, @Nullable String debugLabel) {
        this.width = width;
        this.height = height;
        this.colorAttachments = colorAttachments;
        this.depthAttachment = depthAttachment;
        this.hasStencil = depthAttachment != null && (depthAttachment.getFormat() == 35056 || depthAttachment.getFormat() == 36013);
        this.debugLabel = debugLabel;
        int mask = 0;
        if (this.hasColorAttachment(0)) {
            mask |= 0x4000;
        }
        if (this.hasDepthAttachment()) {
            mask |= 0x100;
        }
        if (this.hasStencilAttachment()) {
            mask |= 0x400;
        }
        this.clearMask = mask;
        this.drawBuffers = IntStream.range(0, this.colorAttachments.length).map(i -> 36064 + i).toArray();
        this.wrapper = Suppliers.memoize(() -> new Wrapper(this));
    }

    @Override
    public void bind(boolean setViewport) {
        GlStateManager._glBindFramebuffer((int)36160, (int)this.id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    @Override
    public void bindDraw(boolean setViewport) {
        GlStateManager._glBindFramebuffer((int)36009, (int)this.id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    public void free() {
        if (this.id == -1) {
            return;
        }
        GL30C.glDeleteFramebuffers((int)this.id);
        this.id = -1;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.free();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.free();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getColorAttachments() {
        return this.colorAttachments.length;
    }

    @Override
    public int getClearMask() {
        return this.clearMask;
    }

    @Override
    public int[] getDrawBuffers() {
        return this.drawBuffers;
    }

    @Override
    public boolean hasColorAttachment(int attachment) {
        return attachment >= 0 && attachment < this.colorAttachments.length;
    }

    @Override
    public boolean hasDepthAttachment() {
        return this.depthAttachment != null;
    }

    @Override
    public boolean hasStencilAttachment() {
        return this.hasStencil;
    }

    @Override
    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorAttachments[attachment];
    }

    @Override
    public AdvancedFboAttachment getDepthAttachment() {
        return Objects.requireNonNull(this.depthAttachment, "Depth attachment does not exist.");
    }

    @Override
    @Nullable
    public String getDebugLabel() {
        return this.debugLabel;
    }

    public Wrapper toRenderTarget() {
        return this.wrapper.get();
    }

    @ApiStatus.Internal
    public static AdvancedFbo.Builder copy(class_276 parent) {
        if (parent instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)parent;
            AdvancedFboImpl fbo = wrapper.fbo();
            return new AdvancedFbo.Builder(fbo.getWidth(), fbo.getHeight()).addAttachments(fbo);
        }
        return new AdvancedFbo.Builder(parent.field_1482, parent.field_1481).addAttachments(parent);
    }

    public static class Wrapper
    extends class_6367 {
        private final float[] clearChannels = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        private final AdvancedFboImpl fbo;

        private Wrapper(AdvancedFboImpl fbo) {
            super(fbo.width, fbo.height, fbo.hasDepthAttachment(), class_310.field_1703);
            this.fbo = fbo;
            this.field_1482 = this.fbo.getWidth();
            this.field_1481 = this.fbo.getHeight();
            this.field_1480 = this.field_1482;
            this.field_1477 = this.field_1481;
            this.field_1476 = this.fbo.id;
            this.field_1475 = this.fbo.isColorTextureAttachment(0) ? this.fbo.getColorTextureAttachment(0).method_4624() : 0;
            this.field_1474 = this.fbo.isDepthTextureAttachment() ? this.fbo.getDepthTextureAttachment().method_4624() : 0;
        }

        public void method_1234(int width, int height, boolean onMac) {
        }

        public void method_1238() {
            throw new UnsupportedOperationException("Cannot destroy advanced fbo from wrapper");
        }

        public void method_1231(int width, int height, boolean onMac) {
        }

        public void method_58226(int framebufferFilter) {
            this.field_1483 = framebufferFilter;
            if (VeilRenderSystem.directStateAccessSupported()) {
                for (int i = 0; i < this.fbo.getColorAttachments(); ++i) {
                    int texture = this.fbo.getColorTextureAttachment(i).method_4624();
                    ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10241, (int)framebufferFilter);
                    ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10240, (int)framebufferFilter);
                    ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10242, (int)33071);
                    ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10243, (int)33071);
                }
            } else {
                for (int i = 0; i < this.fbo.getColorAttachments(); ++i) {
                    this.fbo.getColorAttachment(i).bindAttachment();
                    GlStateManager._texParameter((int)3553, (int)10241, (int)framebufferFilter);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)framebufferFilter);
                    GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
                    GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
                }
                GlStateManager._bindTexture((int)0);
            }
        }

        public void method_1236(float red, float green, float blue, float alpha) {
            super.method_1236(red, green, blue, alpha);
            this.clearChannels[0] = red;
            this.clearChannels[1] = green;
            this.clearChannels[2] = blue;
            this.clearChannels[3] = alpha;
        }

        public void method_1230(boolean clearError) {
            RenderSystem.assertOnRenderThreadOrInit();
            this.fbo.clear(this.clearChannels[0], this.clearChannels[1], this.clearChannels[2], this.clearChannels[3], this.fbo.getClearMask());
        }

        public void method_35610() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).bindAttachment();
            }
        }

        public void method_1242() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).unbindAttachment();
            }
        }

        public void method_1235(boolean setViewport) {
            this.fbo.bind(setViewport);
        }

        public AdvancedFboImpl fbo() {
            return this.fbo;
        }
    }
}

