/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.VeilClient;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.impl.resource.VeilPackResources;
import foundry.veil.impl.resource.VeilResourceManagerImpl;
import foundry.veil.impl.resource.VeilResourceRenderer;
import foundry.veil.impl.resource.tree.VeilResourceFolder;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.ImVec2;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourceManagerInspector
extends SingleWindowInspector {
    public static final float ITEM_VERTICAL_PADDING = 3.0f;
    public static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.resource.title");
    public static final class_2561 SEARCH = class_2561.method_43471((String)"inspector.veil.resource.hint.search");
    public static final class_2561 ADD_TOOLTIP = class_2561.method_43471((String)"inspector.veil.resource.button.add_pack");
    public static final class_2561 RELOAD_TOOLTIP = class_2561.method_43471((String)"inspector.veil.resource.button.reload");
    private CompletableFuture<?> reloadFuture;
    private final ImString searchText = new ImString();

    @Override
    public void renderComponents() {
        ImGui.setNextItemWidth((float)(ImGui.getContentRegionAvailX() - 100.0f));
        ImGui.inputTextWithHint((String)"##search", (String)SEARCH.getString(), (ImString)this.searchText);
        ImGui.sameLine();
        ImGui.pushFont((ImFont)VeilRenderSystem.renderer().getEditorManager().getFont(VeilImGuiUtil.ICON_FONT, false, false));
        ImGui.beginDisabled();
        ImGui.setNextItemWidth((float)44.0f);
        if (ImGui.button((String)"\ued59")) {
            // empty if block
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered()) {
            VeilImGuiUtil.setTooltip((class_5348)ADD_TOOLTIP);
        }
        ImGui.sameLine();
        ImGui.setNextItemWidth((float)44.0f);
        ImGui.beginDisabled((this.reloadFuture != null && !this.reloadFuture.isDone() ? 1 : 0) != 0);
        if (ImGui.button((String)"\uf33f")) {
            this.reloadFuture = class_310.method_1551().method_1521();
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered()) {
            VeilImGuiUtil.setTooltip((class_5348)RELOAD_TOOLTIP);
        }
        ImGui.popFont();
        VeilResourceManagerImpl resourceManager = VeilClient.resourceManager();
        ImGui.pushStyleVar((int)11, (float)1.0f, (float)3.0f);
        ImGui.pushStyleVar((int)14, (float)3.0f, (float)0.0f);
        if (ImGui.beginListBox((String)"##file_tree", (float)ImGui.getContentRegionAvailX(), (float)ImGui.getContentRegionAvailY())) {
            if (this.searchText.get().isBlank()) {
                List<VeilPackResources> packs = resourceManager.getAllPacks();
                for (int i = packs.size() - 1; i >= 0; --i) {
                    VeilPackResources pack = packs.get(i);
                    String modid = pack.getName();
                    int color = VeilImGuiUtil.colorOf(modid);
                    boolean open = ImGui.treeNodeEx((String)("##" + modid), (int)3072);
                    ImGui.pushStyleColor((int)0, (int)color);
                    ImGui.sameLine();
                    int icon = pack.getTexture();
                    if (icon != 0) {
                        float size = ImGui.getTextLineHeight();
                        ImVec2 cursorScreenPos = ImGui.getCursorScreenPos();
                        float minX = cursorScreenPos.x;
                        float minY = cursorScreenPos.y + 3.0f + 1.0f;
                        ImGui.getWindowDrawList().addImage((long)icon, minX, minY, minX + size, minY + size);
                        ImGui.setCursorScreenPos((float)(minX + size + 3.0f + 1.0f), (float)cursorScreenPos.y);
                    } else {
                        VeilImGuiUtil.icon(62755, color);
                        ImGui.sameLine();
                    }
                    ImGui.text((String)modid);
                    ImGui.popStyleColor();
                    if (!open) continue;
                    this.renderFolderContents(pack.getRoot());
                    ImGui.treePop();
                }
            } else {
                ArrayDeque<VeilResourceFolder> folders = new ArrayDeque<VeilResourceFolder>();
                final ObjectArrayList resources = new ObjectArrayList();
                for (VeilPackResources pack : resourceManager.getAllPacks()) {
                    folders.add(pack.getRoot());
                }
                while (!folders.isEmpty()) {
                    VeilResourceFolder folder = (VeilResourceFolder)folders.poll();
                    for (VeilResource<?> resource : folder.getResources()) {
                        VeilResourceInfo info = resource.resourceInfo();
                        if (info.hidden() || !info.location().toString().contains(this.searchText.get())) continue;
                        resources.add(resource);
                    }
                    folders.addAll(folder.getSubFolders());
                }
                ImGui.pushStyleVar((int)11, (float)4.0f, (float)4.0f);
                ImGuiListClipper.forEach((int)resources.size(), (int)22, (ImListClipperCallback)new ImListClipperCallback(this){

                    public void accept(int index) {
                        VeilResource resource = (VeilResource)resources.get(index);
                        float startX = ImGui.getCursorScreenPosX();
                        ImGui.selectable((String)("##" + String.valueOf(resource.resourceInfo().location())), (boolean)false, (int)16, (float)ImGui.getContentRegionAvailX(), (float)22.0f);
                        ImGui.setItemAllowOverlap();
                        ImGui.sameLine();
                        ImGui.setCursorScreenPos((float)startX, (float)ImGui.getCursorScreenPosY());
                        VeilResourceRenderer.renderFilename(resource, true);
                    }
                });
                ImGui.popStyleVar();
            }
            ImGui.endListBox();
        }
        ImGui.popStyleVar();
        ImGui.popStyleVar();
    }

    private int renderFolder(VeilResourceFolder folder) {
        boolean open = ImGui.treeNodeEx((String)("##" + folder.getName()), (int)3072);
        ImGui.sameLine();
        ImGui.beginDisabled();
        ImGui.text((String)"/");
        ImGui.endDisabled();
        ImGui.sameLine();
        ImGui.text((String)folder.getName());
        int count = 1;
        if (open) {
            count += this.renderFolderContents(folder);
            ImGui.treePop();
        }
        return count;
    }

    private int renderFolderContents(VeilResourceFolder folder) {
        int count = 0;
        ImVec2 cursorScreenPos = ImGui.getCursorScreenPos();
        for (VeilResourceFolder subFolder : folder.getSubFolders()) {
            count += this.renderFolder(subFolder);
        }
        ImGui.indent();
        final float cellHeight = ImGui.getTextLineHeight() + 6.0f;
        final ArrayList resources = new ArrayList(folder.getRenderResources());
        ImGuiListClipper.forEach((int)resources.size(), (ImListClipperCallback)new ImListClipperCallback(this){

            public void accept(int index) {
                VeilResource resource = (VeilResource)resources.get(index);
                float startX = ImGui.getCursorScreenPosX();
                ImGui.selectable((String)("##" + String.valueOf(resource.resourceInfo().location())), (boolean)false, (int)16, (float)ImGui.getContentRegionAvailX(), (float)cellHeight);
                ImGui.setItemAllowOverlap();
                ImGui.sameLine();
                ImVec2 selectableCursorScreenPos = ImGui.getCursorScreenPos();
                float shift = (cellHeight - ImGui.getTextLineHeight()) / 2.0f;
                ImGui.setCursorScreenPos((float)startX, (float)(selectableCursorScreenPos.y + shift));
                VeilResourceRenderer.renderFilename(resource, false);
                ImGui.setCursorScreenPos((float)startX, (float)(ImGui.getCursorScreenPosY() - shift));
            }
        });
        float lineX = cursorScreenPos.x - 4.0f;
        ImGui.getWindowDrawList().addRectFilled(lineX, cursorScreenPos.y, lineX + 1.5f, cursorScreenPos.y + (float)(count += resources.size()) * cellHeight, 0x22FFFFFF);
        ImGui.unindent();
        return count;
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return RESOURCE_GROUP;
    }
}

