/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import imgui.ImGui;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PostInspector
extends SingleWindowInspector {
    public static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.post.title");
    private static final class_2561 INACTIVE = class_2561.method_43471((String)"inspector.veil.post.inactive");
    private static final class_2561 ACTIVE = class_2561.method_43471((String)"inspector.veil.post.active");
    private final Set<class_2960> removedPipelines = new HashSet<class_2960>(1);

    private static boolean isInternal(class_2960 id) {
        return "veil".equals(id.method_12836()) && id.method_12832().startsWith("core/");
    }

    @Override
    public void render() {
        ImGui.setNextWindowSize((float)600.0f, (float)0.0f);
        super.render();
    }

    @Override
    public void renderComponents() {
        Object payload;
        this.removedPipelines.clear();
        PostProcessingManager postProcessingManager = VeilRenderSystem.renderer().getPostProcessingManager();
        float availableWidth = ImGui.getContentRegionAvailX();
        ImGui.setNextItemWidth((float)(availableWidth / 2.0f));
        ImGui.beginGroup();
        VeilImGuiUtil.component((class_5348)INACTIVE);
        if (ImGui.beginListBox((String)"##available_pipelines", (float)(availableWidth / 2.0f), (float)0.0f)) {
            for (class_2960 class_29602 : postProcessingManager.getPipelines()) {
                if (postProcessingManager.isActive(class_29602) || PostInspector.isInternal(class_29602)) continue;
                VeilImGuiUtil.resourceLocation(class_29602);
                if (!ImGui.beginDragDropSource((int)8)) continue;
                ImGui.setDragDropPayload((String)"POST_PIPELINE", (Object)class_29602, (int)2);
                VeilImGuiUtil.resourceLocation(class_29602);
                ImGui.endDragDropSource();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (class_2960)ImGui.acceptDragDropPayload((String)"POST_PIPELINE");
            if (payload != null) {
                this.removedPipelines.add((class_2960)payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        ImGui.sameLine();
        ImGui.setNextItemWidth((float)(availableWidth / 2.0f));
        ImGui.beginGroup();
        VeilImGuiUtil.component((class_5348)ACTIVE);
        if (ImGui.beginListBox((String)"##shaders", (float)(availableWidth / 2.0f), (float)0.0f)) {
            for (PostProcessingManager.ProfileEntry profileEntry : postProcessingManager.getActivePipelines()) {
                class_2960 id = profileEntry.getPipeline();
                if (PostInspector.isInternal(id)) continue;
                ImGui.pushID((String)id.toString());
                VeilImGuiUtil.resourceLocation(id);
                if (ImGui.beginDragDropSource((int)8)) {
                    ImGui.setDragDropPayload((String)"POST_PIPELINE", (Object)id, (int)2);
                    VeilImGuiUtil.resourceLocation(id);
                    ImGui.endDragDropSource();
                }
                float priorityWidth = Math.max(ImGui.calcTextSize((String)"999999").x, ImGui.calcTextSize((String)Integer.toString((int)profileEntry.getPriority())).x);
                ImGui.setItemAllowOverlap();
                ImGui.sameLine((float)(ImGui.getContentRegionAvailX() - priorityWidth - 2.0f));
                ImGui.setNextItemWidth((float)priorityWidth);
                int[] editPriority = new int[profileEntry.getPriority()];
                if (ImGui.dragScalar((String)"##priority", (int[])editPriority, (float)1.0f)) {
                    profileEntry.setPriority(editPriority[0]);
                }
                ImGui.popID();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (class_2960)ImGui.acceptDragDropPayload((String)"POST_PIPELINE");
            if (payload != null) {
                postProcessingManager.add((class_2960)payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        for (class_2960 class_29603 : this.removedPipelines) {
            postProcessingManager.remove(class_29603);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return RENDERER_GROUP;
    }
}

