/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModNioResourcePack.class}, remap=false)
public abstract class ModNioResourcePackMixin
implements ModResourcePack,
PackResourcesExtension {
    @Shadow
    @Final
    private List<Path> basePaths;
    @Shadow
    @Final
    private Map<class_3264, Set<String>> namespaces;
    @Shadow
    @Final
    private ModContainer mod;

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        for (final Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            for (Map.Entry<class_3264, Set<String>> entry : this.namespaces.entrySet()) {
                final class_3264 type = entry.getKey();
                for (final String namespace : entry.getValue()) {
                    final Path nsPath = basePath.resolve(type.method_14413()).resolve(namespace);
                    if (!Files.exists(nsPath, new LinkOption[0])) continue;
                    try {
                        Files.walkFileTree(nsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                String filename = nsPath.relativize(file).toString().replace(separator, "/");
                                class_2960 name = class_2960.method_43902((String)namespace, (String)filename);
                                if (name != null) {
                                    consumer.accept(type, name, nsPath, file, PackResourcesExtension.findDevPath(basePath, file));
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        Veil.LOGGER.warn("findResources in namespace {}, mod {} failed!", new Object[]{namespace, this.mod.getMetadata().getId(), e});
                    }
                }
            }
        }
    }

    @Override
    public boolean veil$isStatic() {
        boolean dynamic = false;
        for (Path basePath : this.basePaths) {
            if (basePath.getFileSystem() != FileSystems.getDefault()) continue;
            dynamic = true;
        }
        return !dynamic;
    }

    @Override
    public List<Path> veil$getRawResourceRoots() {
        return this.basePaths.stream().flatMap(path -> PackResourcesExtension.findDevPaths(path, path).stream()).toList();
    }

    @Override
    @Nullable
    public class_7367<InputStream> veil$getIcon() {
        ModMetadata metadata = this.mod.getMetadata();
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(metadata.getId()).orElseThrow();
        return metadata.getIconPath(20).flatMap(arg_0 -> ((ModContainer)modContainer).findPath(arg_0)).map(path -> () -> Files.newInputStream(path, new OpenOption[0])).orElse(null);
    }

    @Override
    public boolean veil$blurIcon() {
        return false;
    }

    @Override
    public Stream<class_3262> veil$listPacks() {
        ModMetadata metadata = this.mod.getMetadata();
        String id = metadata.getId();
        if (!"fabric-api".equalsIgnoreCase(id) && id.startsWith("fabric") && metadata.containsCustomValue("fabric-api:module-lifecycle")) {
            return Stream.empty();
        }
        return Stream.of(this);
    }
}

