/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.compat.sodium;

import foundry.veil.ext.sodium.ChunkVertexEncoderVertexExtension;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.impl.DefaultChunkMeshAttributes;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexFormatAttribute;
import net.minecraft.class_3532;
import org.lwjgl.system.MemoryUtil;

public class VeilChunkVertex
implements ChunkVertexType {
    public static final int STRIDE = 24;
    public static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder((int)24).addElement(DefaultChunkMeshAttributes.POSITION, 0, 0).addElement(DefaultChunkMeshAttributes.COLOR, 1, 8).addElement(DefaultChunkMeshAttributes.TEXTURE, 2, 12).addElement(DefaultChunkMeshAttributes.LIGHT_MATERIAL_INDEX, 3, 16).addElement(new VertexFormatAttribute("NORMAL_INDEX", GlVertexAttributeFormat.BYTE, 4, true, false), 4, 20).build();
    private static final int POSITION_MAX_VALUE = 0x100000;
    private static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;

    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public ChunkVertexEncoder getEncoder() {
        return (ptr, materialBits, vertices, section) -> {
            float texCentroidU = 0.0f;
            float texCentroidV = 0.0f;
            for (ChunkVertexEncoder.Vertex vertex : vertices) {
                texCentroidU += vertex.u;
                texCentroidV += vertex.v;
            }
            texCentroidU *= 0.25f;
            texCentroidV *= 0.25f;
            for (int i = 0; i < 4; ++i) {
                ChunkVertexEncoder.Vertex vertex = vertices[i];
                int x = VeilChunkVertex.quantizePosition(vertex.x);
                int y = VeilChunkVertex.quantizePosition(vertex.y);
                int z = VeilChunkVertex.quantizePosition(vertex.z);
                int u = VeilChunkVertex.encodeTexture(texCentroidU, vertex.u);
                int v = VeilChunkVertex.encodeTexture(texCentroidV, vertex.v);
                int light = VeilChunkVertex.encodeLight(vertex.light);
                MemoryUtil.memPutInt((long)ptr, (int)VeilChunkVertex.packPositionHi(x, y, z));
                MemoryUtil.memPutInt((long)(ptr + 4L), (int)VeilChunkVertex.packPositionLo(x, y, z));
                MemoryUtil.memPutInt((long)(ptr + 8L), (int)ColorARGB.mulRGB((int)vertex.color, (float)vertex.ao));
                MemoryUtil.memPutInt((long)(ptr + 12L), (int)VeilChunkVertex.packTexture(u, v));
                MemoryUtil.memPutInt((long)(ptr + 16L), (int)VeilChunkVertex.packLightAndData(light, materialBits, section));
                ChunkVertexEncoderVertexExtension ext = (ChunkVertexEncoderVertexExtension)vertex;
                MemoryUtil.memPutInt((long)(ptr + 20L), (int)ext.veil$getPackedNormal());
                ptr += 24L;
            }
            return ptr;
        };
    }

    private static int packPositionHi(int x, int y, int z) {
        return x >>> 10 & 0x3FF | (y >>> 10 & 0x3FF) << 10 | (z >>> 10 & 0x3FF) << 20;
    }

    private static int packPositionLo(int x, int y, int z) {
        return x & 0x3FF | (y & 0x3FF) << 10 | (z & 0x3FF) << 20;
    }

    private static int quantizePosition(float position) {
        return (int)(VeilChunkVertex.normalizePosition(position) * 1048576.0f) & 0xFFFFF;
    }

    private static float normalizePosition(float v) {
        return (8.0f + v) / 32.0f;
    }

    private static int packTexture(int u, int v) {
        return u & 0xFFFF | (v & 0xFFFF) << 16;
    }

    private static int encodeTexture(float center, float x) {
        int bias = x < center ? 1 : -1;
        int quantized = VeilChunkVertex.floorInt(x * 32768.0f) + bias;
        return quantized & Short.MAX_VALUE | VeilChunkVertex.sign(bias) << 15;
    }

    private static int encodeLight(int light) {
        int sky = class_3532.method_15340((int)(light >>> 16 & 0xFF), (int)8, (int)248);
        int block = class_3532.method_15340((int)(light & 0xFF), (int)8, (int)248);
        return block | sky << 8;
    }

    private static int packLightAndData(int light, int material, int section) {
        return light & 0xFFFF | (material & 0xFF) << 16 | (section & 0xFF) << 24;
    }

    private static int sign(int x) {
        return x >>> 31;
    }

    private static int floorInt(float x) {
        return (int)Math.floor(x);
    }
}

