/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.fabric.util.FabricReloadListener;
import foundry.veil.impl.ClientEnumArgument;
import foundry.veil.impl.VeilBuiltinPacks;
import foundry.veil.impl.VeilReloadListeners;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2280;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        VeilClient.init();
        HudRenderCallback.EVENT.register(VeilUITooltipRenderer::renderOverlay);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> client.execute(VeilRenderSystem.renderer().getLightRenderer()::free));
        KeyBindingHelper.registerKeyBinding((class_304)VeilClient.EDITOR_KEY);
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("veil").orElseThrow();
        VeilBuiltinPacks.registerPacks((id, defaultEnabled) -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)id, (ModContainer)container, (ResourcePackActivationType)(defaultEnabled ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL)));
        CoreShaderRegistrationCallback.EVENT.register(context -> VeilVanillaShaders.registerShaders((arg_0, arg_1, arg_2) -> ((CoreShaderRegistrationCallback.RegistrationContext)context).register(arg_0, arg_1, arg_2)));
        VeilReloadListeners.registerListeners((type, id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener(Veil.veilPath(id), listener)));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)"quasar");
            builder.then(ClientCommandManager.argument((String)"emitter", (ArgumentType)class_2232.method_9441()).suggests(QuasarParticles.emitterSuggestionProvider()).then(ClientCommandManager.argument((String)"position", (ArgumentType)class_2277.method_9737()).executes(ctx -> {
                class_2960 id = (class_2960)ctx.getArgument("emitter", class_2960.class);
                FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
                ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
                ParticleEmitter instance = particleManager.createEmitter(id);
                if (instance == null) {
                    source.sendError((class_2561)class_2561.method_43470((String)("Unknown emitter: " + String.valueOf(id))));
                    return 0;
                }
                class_2280 coordinates = (class_2280)ctx.getArgument("position", class_2280.class);
                class_243 pos = coordinates.method_9708(source.getEntity().method_5671());
                instance.setPosition(pos.field_1352, pos.field_1351, pos.field_1350);
                particleManager.addParticleSystem(instance);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Spawned " + String.valueOf(id))));
                return 1;
            })));
            dispatcher.register(builder);
            if (Veil.platform().isDevelopmentEnvironment()) {
                class_2960 bufferId = Veil.veilPath("forced");
                LiteralArgumentBuilder debugBuilder = LiteralArgumentBuilder.literal((String)"veil");
                debugBuilder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"buffers").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"enable").then(ClientCommandManager.argument((String)"buffer", ClientEnumArgument.enumArgument(DynamicBufferType.class)).executes(ctx -> {
                    DynamicBufferType value = (DynamicBufferType)((Object)((Object)((Object)ctx.getArgument("buffer", DynamicBufferType.class))));
                    VeilRenderSystem.renderer().enableBuffers(bufferId, value);
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.veil.buffers.enable", (Object[])new Object[]{value.name().toLowerCase(Locale.ROOT)}));
                    return 1;
                }))).then(ClientCommandManager.literal((String)"all").executes(ctx -> {
                    DynamicBufferType[] values = DynamicBufferType.values();
                    VeilRenderSystem.renderer().enableBuffers(bufferId, values);
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.veil.buffers.enable.all"));
                    return values.length;
                })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"disable").then(ClientCommandManager.argument((String)"buffer", ClientEnumArgument.enumArgument(DynamicBufferType.class)).executes(ctx -> {
                    DynamicBufferType value = (DynamicBufferType)((Object)((Object)((Object)ctx.getArgument("buffer", DynamicBufferType.class))));
                    VeilRenderSystem.renderer().disableBuffers(bufferId, value);
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.veil.buffers.disable", (Object[])new Object[]{value.name().toLowerCase(Locale.ROOT)}));
                    return 1;
                }))).then(ClientCommandManager.literal((String)"all").executes(ctx -> {
                    DynamicBufferType[] values = DynamicBufferType.values();
                    VeilRenderSystem.renderer().disableBuffers(bufferId, values);
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.veil.buffers.disable.all"));
                    return values.length;
                }))));
                dispatcher.register(debugBuilder);
            }
        });
    }
}

