/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.type;

import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.util.CompositeReloadListener;
import foundry.veil.ext.TextureAtlasExtension;
import foundry.veil.mixin.resource.accessor.ResourceAtlasSetAccessor;
import foundry.veil.mixin.resource.accessor.ResourceModelManagerAccessor;
import foundry.veil.mixin.resource.accessor.ResourceTextureAtlasAccessor;
import imgui.ImGui;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1092;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_4724;
import net.minecraft.class_7766;
import net.minecraft.class_7948;

public record TextureResource(VeilResourceInfo resourceInfo) implements VeilResource<TextureResource>
{
    @Override
    public void render(boolean dragging, boolean fullName) {
        float size = ImGui.getTextLineHeight();
        int texture = class_310.method_1551().method_1531().method_4619(this.resourceInfo.location()).method_4624();
        ImGui.pushStyleColor((int)0, (int)(this.resourceInfo.isStatic() ? -5592406 : -1));
        if (dragging) {
            ImGui.image((long)texture, (float)(size * 8.0f), (float)(size * 8.0f));
            VeilImGuiUtil.resourceLocation(this.resourceInfo().location());
        } else {
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.image((long)texture, (float)size, (float)size);
            ImGui.sameLine();
            ImGui.popStyleVar();
            if (ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.image((long)texture, (float)(size * 16.0f), (float)(size * 16.0f));
                ImGui.endTooltip();
            }
            ImGui.sameLine();
            if (fullName) {
                VeilImGuiUtil.resourceLocation(this.resourceInfo.location());
            } else {
                ImGui.text((String)this.resourceInfo.fileName());
            }
        }
        ImGui.popStyleColor();
    }

    @Override
    public List<VeilResourceAction<TextureResource>> getActions() {
        return List.of();
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) throws IOException {
        class_2960 location = this.resourceInfo.location();
        class_3300 resources = resourceManager.resources(this.resourceInfo);
        class_310 client = class_310.method_1551();
        class_1060 textureManager = client.method_1531();
        class_1044 texture = textureManager.method_34590(location, null);
        if (texture != null) {
            texture.method_18169(textureManager, resources, location, (Executor)client);
        }
        class_1092 modelManager = client.method_1554();
        class_4724 atlases = ((ResourceModelManagerAccessor)modelManager).getAtlases();
        class_2960 id = class_7948.field_42075.method_45115(location);
        boolean reloadRequired = false;
        for (Map.Entry<class_2960, class_4724.class_7772> entry : ((ResourceAtlasSetAccessor)atlases).getAtlases().entrySet()) {
            if (!((TextureAtlasExtension)entry.getValue().comp_1051()).veil$hasTexture(id)) continue;
            reloadRequired = true;
            break;
        }
        if (SodiumCompat.INSTANCE != null) {
            if (reloadRequired) {
                CompositeReloadListener.of(new class_3302[]{modelManager, client.method_1541(), client.method_1480()}).method_25931(CompletableFuture::completedFuture, resources, (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, (Executor)class_156.method_18349(), (Executor)client).thenRunAsync(VeilRenderSystem::rebuildChunks, VeilRenderSystem.renderThreadExecutor());
            }
        } else {
            for (Map.Entry<class_2960, class_4724.class_7772> entry : ((ResourceAtlasSetAccessor)atlases).getAtlases().entrySet()) {
                class_1059 atlas = entry.getValue().comp_1051();
                if (!((TextureAtlasExtension)atlas).veil$hasTexture(id)) continue;
                int mipLevel = ((ResourceTextureAtlasAccessor)atlas).getMipLevel();
                ((CompletableFuture)class_7766.method_45837((class_1059)atlas).method_52849(resources, entry.getValue().comp_1168(), mipLevel, (Executor)class_156.method_18349()).thenCompose(class_7766.class_7767::method_45845)).thenAcceptAsync(preparations -> {
                    atlas.method_45848(preparations);
                    VeilRenderSystem.rebuildChunks();
                }, VeilRenderSystem.renderThreadExecutor());
            }
        }
    }

    @Override
    public int getIconCode() {
        return 62405;
    }
}

