/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.ext.PackResourcesExtension;
import imgui.ImGui;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5348;

public class ResourceOverrideEditor
implements ResourceFileEditor<VeilResource<?>> {
    private static final class_2561 NAME = class_2561.method_43471((String)"resource.veil.action.override");
    private final VeilEditorEnvironment environment;
    private final VeilResource<?> veilResource;
    private final List<Path> options = new ObjectArrayList();
    private boolean closed = false;
    private boolean opened = false;

    public ResourceOverrideEditor(VeilEditorEnvironment environment, VeilResource<?> veilResource) {
        this.environment = environment;
        this.veilResource = veilResource;
        VeilResourceManager resourceManager = this.environment.getResourceManager();
        for (class_3262 pack : resourceManager.clientResources().method_29213().toList()) {
            List<Path> packRoots;
            PackResourcesExtension ext;
            if (!(pack instanceof PackResourcesExtension) || (ext = (PackResourcesExtension)pack).veil$isStatic() || (packRoots = ext.veil$getRawResourceRoots()).isEmpty()) continue;
            class_2960 location = this.veilResource.resourceInfo().location();
            for (Path devRoot : packRoots) {
                this.options.add(devRoot.resolve(class_3264.field_14188.method_14413()).resolve(location.method_12836()).resolve(location.method_12832()));
            }
        }
    }

    @Override
    public void render() {
        if (!this.opened) {
            this.opened = true;
            ImGui.openPopup((String)"##asset_override");
        }
        if (!ImGui.beginPopup((String)"##asset_override")) {
            this.closed = true;
            return;
        }
        VeilImGuiUtil.component((class_5348)NAME);
        VeilResourceManager resourceManager = this.environment.getResourceManager();
        for (Path writePath : this.options) {
            if (ImGui.selectable((String)writePath.toString(), (boolean)false, (int)16)) {
                Veil.LOGGER.info("Writing to {}", (Object)writePath);
                VeilResourceInfo info = this.veilResource.resourceInfo();
                try (InputStream stream = info.open(resourceManager);){
                    Files.copy(stream, writePath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    Veil.LOGGER.error("Failed to copy file: {}", (Object)info.location(), (Object)e);
                }
            }
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            ImGui.text((String)writePath.toString());
            ImGui.setItemAllowOverlap();
        }
        if (this.options.isEmpty()) {
            ImGui.textDisabled((String)"No valid packs");
        }
        ImGui.endPopup();
    }

    @Override
    public void loadFromDisk() {
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public VeilResource<?> getResource() {
        return this.veilResource;
    }
}

