/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.BlockModelResource;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1088;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class BlockModelInspector
implements ResourceFileEditor<BlockModelResource> {
    private static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.block_model.title");
    private static final class_796 FACE_BAKERY = new class_796();
    private static final class_4587.class_4665 POSE = new class_4587().method_23760();
    private final ImBoolean open = new ImBoolean(true);
    private final VeilResourceManager resourceManager;
    private final BlockModelResource resource;
    private ObjectArrayList<class_777> quads;

    public BlockModelInspector(VeilEditorEnvironment environment, BlockModelResource resource) {
        this.resourceManager = environment.getResourceManager();
        this.resource = resource;
        this.loadFromDisk();
    }

    @Override
    public void render() {
        if (this.resource == null || !this.open.get()) {
            return;
        }
        VeilResourceInfo resourceInfo = this.resource.resourceInfo();
        ImGui.setNextWindowSizeConstraints((float)256.0f, (float)256.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        ImGui.setNextWindowSize((float)256.0f, (float)256.0f, (int)2);
        if (ImGui.begin((String)(TITLE.getString() + "###model_editor_" + resourceInfo.fileName()), (ImBoolean)this.open, (int)264)) {
            VeilImGuiUtil.resourceLocation(resourceInfo.location());
            int desiredWidth = ((int)ImGui.getContentRegionAvailX() - 2) * 2;
            int desiredHeight = ((int)ImGui.getContentRegionAvailY() - 2) * 2;
            if (desiredWidth <= 0 || desiredHeight <= 0) {
                ImGui.end();
                return;
            }
            int texture = VeilImGuiUtil.renderArea(desiredWidth, desiredHeight, fbo -> {
                double time = ImGui.getTime();
                double yaw = Math.toRadians(time * 45.0);
                double pitch = Math.toRadians(30.0);
                Quaterniond cameraOrientation = new Quaterniond().rotateX(pitch).rotateY(yaw);
                Vector3d cameraPos = cameraOrientation.transformInverse(new Vector3d(0.0, 0.0, 2.8)).add(0.5, 0.5, 0.5);
                Matrix4f viewMatrix = new Matrix4f().rotate((Quaternionfc)new Quaternionf((Quaterniondc)cameraOrientation)).translate((float)(-cameraPos.x), (float)(-cameraPos.y), (float)(-cameraPos.z));
                float aspect = (float)desiredWidth / (float)desiredHeight;
                Matrix4f projMat = new Matrix4f().perspective((float)Math.toRadians(40.0), aspect, 0.3f, 1000.0f);
                Matrix4f modelView = new Matrix4f().mul((Matrix4fc)viewMatrix);
                class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1590);
                for (class_777 quad : this.quads) {
                    builder.method_22919(POSE, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
                }
                class_9801 data = builder.method_60794();
                if (data != null) {
                    class_1921 renderType = class_1921.method_23583();
                    Matrix4fStack stack = RenderSystem.getModelViewStack();
                    stack.pushMatrix();
                    stack.set((Matrix4fc)modelView);
                    RenderSystem.applyModelViewMatrix();
                    RenderSystem.backupProjectionMatrix();
                    RenderSystem.setProjectionMatrix((Matrix4f)projMat, (class_8251)class_8251.field_43361);
                    renderType.method_60895(data);
                    stack.popMatrix();
                    RenderSystem.restoreProjectionMatrix();
                    RenderSystem.applyModelViewMatrix();
                    renderType.method_23518();
                }
            });
            if (ImGui.beginChild((String)"3D View", (float)((float)desiredWidth / 2.0f + 2.0f), (float)((float)desiredHeight / 2.0f + 2.0f), (boolean)false, (int)8)) {
                ImGui.image((long)texture, (float)((float)desiredWidth / 2.0f), (float)((float)desiredHeight / 2.0f), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            }
            ImGui.endChild();
        }
        ImGui.end();
    }

    @Override
    public boolean isClosed() {
        return !this.open.get();
    }

    @Override
    public BlockModelResource getResource() {
        return this.resource;
    }

    @Override
    public void loadFromDisk() {
        class_310 client = class_310.method_1551();
        this.quads = new ObjectArrayList();
        try (BufferedReader reader = this.resource.resourceInfo().openAsReader(this.resourceManager);){
            class_793 unbaked = class_793.method_3437((Reader)reader);
            unbaked.method_45785(location -> {
                class_793 class_7932;
                block8: {
                    BufferedReader parentReader = client.method_1478().openAsReader(class_1088.field_40570.method_45112(location));
                    try {
                        class_7932 = class_793.method_3437((Reader)parentReader);
                        if (parentReader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parentReader != null) {
                                try {
                                    ((Reader)parentReader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            Veil.LOGGER.error("Failed to load block model", (Throwable)e);
                            return class_793.method_3430((String)class_1088.field_5371);
                        }
                    }
                    ((Reader)parentReader).close();
                }
                return class_7932;
            });
            List elements = unbaked.method_3433();
            for (class_785 blockelement : elements) {
                for (class_2350 direction : blockelement.field_4230.keySet()) {
                    class_783 blockelementface = (class_783)blockelement.field_4230.get(direction);
                    class_4730 material = unbaked.method_24077(blockelementface.comp_2869());
                    class_1058 sprite = (class_1058)client.method_1549(material.method_24144()).apply(material.method_24147());
                    this.quads.add((Object)FACE_BAKERY.method_3468(blockelement.field_4228, blockelement.field_4231, blockelementface, sprite, direction, (class_3665)class_1086.field_5350, blockelement.field_4232, blockelement.field_4229));
                }
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to load block model", (Throwable)e);
        }
    }
}

