/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.EmitterShapeSettings;
import foundry.veil.api.quasar.data.ParticleEmitterData;
import foundry.veil.api.quasar.data.ParticleSettings;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.resource.VeilDynamicRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7655;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class QuasarParticles {
    public static final class_5321<class_2378<ParticleModuleData>> INIT_MODULES = QuasarParticles.createRegistryKey("quasar/modules/init");
    public static final class_5321<class_2378<ParticleModuleData>> UPDATE_MODULES = QuasarParticles.createRegistryKey("quasar/modules/update");
    public static final class_5321<class_2378<ParticleModuleData>> RENDER_MODULES = QuasarParticles.createRegistryKey("quasar/modules/render");
    public static final class_5321<class_2378<QuasarParticleData>> PARTICLE_DATA = QuasarParticles.createRegistryKey("quasar/modules/particle_data");
    public static final class_5321<class_2378<ParticleSettings>> PARTICLE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/particle");
    public static final class_5321<class_2378<EmitterShapeSettings>> EMITTER_SHAPE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/shape");
    public static final class_5321<class_2378<ParticleEmitterData>> EMITTER = QuasarParticles.createRegistryKey("quasar/emitters");
    private static final SuggestionProvider<?> EMITTER_SUGGESTION_PROVIDER = (unused, builder) -> QuasarParticles.registryAccess().method_33310(EMITTER).map(registry -> class_2172.method_9270((Iterable)registry.method_10235(), (SuggestionsBuilder)builder)).orElseGet(Suggestions::empty);
    private static final List<class_7655.class_7657<?>> REGISTRIES = List.of(new class_7655.class_7657(INIT_MODULES, ParticleModuleData.INIT_DIRECT_CODEC, false), new class_7655.class_7657(UPDATE_MODULES, ParticleModuleData.UPDATE_DIRECT_CODEC, false), new class_7655.class_7657(RENDER_MODULES, ParticleModuleData.RENDER_DIRECT_CODEC, false), new class_7655.class_7657(PARTICLE_DATA, QuasarParticleData.DIRECT_CODEC, false), new class_7655.class_7657(PARTICLE_SETTINGS, ParticleSettings.DIRECT_CODEC, false), new class_7655.class_7657(EMITTER_SHAPE_SETTINGS, EmitterShapeSettings.DIRECT_CODEC, false), new class_7655.class_7657(EMITTER, ParticleEmitterData.DIRECT_CODEC, false));
    private static class_5455 registryAccess = class_5455.field_40585;

    private QuasarParticles() {
    }

    private static <T> class_5321<class_2378<T>> createRegistryKey(String name) {
        return class_5321.method_29180((class_2960)Veil.veilPath(name));
    }

    public static <T extends class_2172> SuggestionProvider<T> emitterSuggestionProvider() {
        return EMITTER_SUGGESTION_PROVIDER;
    }

    public static class_5455 registryAccess() {
        return registryAccess;
    }

    @ApiStatus.Internal
    public static class Reloader
    implements class_3302 {
        @NotNull
        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            return ((CompletableFuture)VeilDynamicRegistry.loadRegistries(resourceManager, REGISTRIES, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(data -> {
                registryAccess = data.registryAccess();
                ParticleEmitter.clearErrors();
                String msg = VeilDynamicRegistry.printErrors(data.errors());
                if (msg != null) {
                    Veil.LOGGER.error("Quasar registry loading errors:{}", (Object)msg);
                }
                Veil.LOGGER.info("Loaded {} quasar particles", (Object)registryAccess.method_30530(EMITTER).method_10204());
                VeilRenderSystem.renderer().getParticleManager().clear();
            }, gameExecutor);
        }

        @NotNull
        public String method_22322() {
            return QuasarParticles.class.getSimpleName();
        }
    }
}

