/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.vertex;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import java.util.List;
import net.minecraft.class_293;
import net.minecraft.class_296;
import org.jetbrains.annotations.ApiStatus;

public interface VertexArrayBuilder {
    @ApiStatus.Internal
    public static void validateRelativeOffset(int offset) {
        if (offset < 0 || offset > VeilRenderSystem.maxVertexAttributeRelativeOffset()) {
            throw new IllegalArgumentException("Vertex array attribute relative offset must be between 0 and " + VeilRenderSystem.maxVertexAttributeRelativeOffset() + ". Was " + offset);
        }
    }

    public VertexArray vertexArray();

    default public VertexArrayBuilder applyFrom(int bufferIndex, int buffer, int attributeStart, class_293 format) {
        this.defineVertexBuffer(bufferIndex, buffer, 0, format.method_1362(), 0);
        List elements = format.method_1357();
        for (int i = 0; i < elements.size(); ++i) {
            class_296 element = (class_296)elements.get(i);
            class_296.class_298 usage = element.comp_2845();
            if (usage == class_296.class_298.field_1636 && element.comp_2844() != class_296.class_297.field_1623) {
                this.setVertexIAttribute(attributeStart + i, bufferIndex, element.comp_2846(), DataType.fromType(element.comp_2844()), format.method_60835(element));
                continue;
            }
            this.setVertexAttribute(attributeStart + i, bufferIndex, element.comp_2846(), DataType.fromType(element.comp_2844()), usage == class_296.class_298.field_1635 || usage == class_296.class_298.field_1632, format.method_60835(element));
        }
        return this;
    }

    public VertexArrayBuilder defineVertexBuffer(int var1, int var2, int var3, int var4, int var5);

    public VertexArrayBuilder setVertexAttribute(int var1, int var2, int var3, DataType var4, boolean var5, int var6);

    public VertexArrayBuilder setVertexIAttribute(int var1, int var2, int var3, DataType var4, int var5);

    public VertexArrayBuilder setVertexLAttribute(int var1, int var2, int var3, DataType var4, int var5);

    public VertexArrayBuilder removeVertexBuffer(int var1);

    public VertexArrayBuilder removeAttribute(int var1);

    public VertexArrayBuilder clearVertexBuffers();

    public VertexArrayBuilder clearVertexAttributes();

    public static enum DataType {
        BYTE(5120),
        SHORT(5122),
        INT(5124),
        FIXED(5132),
        FLOAT(5126),
        HALF_FLOAT(5131),
        DOUBLE(5130),
        UNSIGNED_BYTE(5121),
        UNSIGNED_SHORT(5123),
        UNSIGNED_INT(5125),
        INT_2_10_10_10_REV(36255),
        UNSIGNED_INT_2_10_10_10_REV(33640),
        UNSIGNED_INT_10F_11F_11F_REV(35899);

        private final int glType;

        private DataType(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }

        public static DataType fromType(class_296.class_297 type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case class_296.class_297.field_1623 -> FLOAT;
                case class_296.class_297.field_1624 -> UNSIGNED_BYTE;
                case class_296.class_297.field_1621 -> BYTE;
                case class_296.class_297.field_1622 -> UNSIGNED_SHORT;
                case class_296.class_297.field_1625 -> SHORT;
                case class_296.class_297.field_1619 -> UNSIGNED_INT;
                case class_296.class_297.field_1617 -> INT;
            };
        }
    }
}

