/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public final class LightRenderer
implements NativeResource {
    private static final class_2960 BUFFER_ID = Veil.veilPath("lights");
    private final Map<LightTypeRegistry.LightType<?>, LightData<?>> lights = new HashMap();
    private boolean ambientOcclusionEnabled = true;

    public boolean applyShader() {
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader == null) {
            return true;
        }
        shader.bind();
        AdvancedFbo fbo = AdvancedFbo.getMainFramebuffer();
        shader.setFramebufferSamplers(fbo);
        ShaderUniform screenSize = shader.getUniform("ScreenSize");
        if (screenSize != null) {
            screenSize.setVector(fbo.getWidth(), fbo.getHeight());
        }
        DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
        for (DynamicBufferType dynamicBuffer : DynamicBufferType.values()) {
            shader.setSampler(dynamicBuffer.getSourceName() + "Sampler", bufferManger.getBufferTexture(dynamicBuffer));
        }
        shader.bindSamplers(0);
        return false;
    }

    @ApiStatus.Internal
    public void setup(CullFrustum frustum) {
        for (Map.Entry<LightTypeRegistry.LightType<?>, LightData<?>> entry : this.lights.entrySet()) {
            entry.getValue().prepare(this, frustum);
        }
    }

    @ApiStatus.Internal
    public boolean render(AdvancedFbo lightFbo) {
        boolean hasRendered = false;
        VeilRenderer renderer = VeilRenderSystem.renderer();
        for (LightData<?> value : this.lights.values()) {
            if (value.renderer.getVisibleLights() <= 0) continue;
            if (!hasRendered) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                RenderSystem.depthMask((boolean)false);
                lightFbo.bind(true);
                lightFbo.clear();
            }
            hasRendered = true;
            if (renderer.enableBuffers(BUFFER_ID, DynamicBufferType.ALBEDO, DynamicBufferType.NORMAL)) break;
            value.render(this);
        }
        if (hasRendered) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        } else {
            renderer.disableBuffers(BUFFER_ID, DynamicBufferType.ALBEDO, DynamicBufferType.NORMAL);
        }
        return hasRendered;
    }

    public void addLight(Light light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        this.lights.computeIfAbsent(light.getType(), LightData::new).addLight(light);
    }

    public <T extends Light> void removeLight(T light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        LightData<?> data = this.lights.get(light.getType());
        if (data != null) {
            data.removedLights.add(light);
        }
    }

    public <T extends Light> List<T> getLights(LightTypeRegistry.LightType<? extends T> type) {
        LightData<?> data = this.lights.get(type);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.lightsView;
    }

    public void enableAmbientOcclusion() {
        if (!this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = true;
            VeilRenderSystem.rebuildChunks();
        }
    }

    public void disableAmbientOcclusion() {
        if (this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = false;
            VeilRenderSystem.rebuildChunks();
        }
    }

    public boolean isAmbientOcclusionEnabled() {
        return this.ambientOcclusionEnabled;
    }

    public void free() {
        this.lights.values().forEach(LightData::free);
        this.lights.clear();
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        int visible = this.lights.values().stream().mapToInt(data -> data.renderer.getVisibleLights()).sum();
        int all = this.lights.values().stream().mapToInt(data -> data.lights.size()).sum();
        consumer.accept("Lights: " + visible + " / " + all);
    }

    @ApiStatus.Internal
    private static class LightData<T extends Light>
    implements NativeResource {
        private final LightTypeRenderer<T> renderer;
        private final List<T> lights;
        private final List<T> lightsView;
        private final Set<T> removedLights;

        private LightData(LightTypeRenderer<T> renderer) {
            this.renderer = renderer;
            this.lights = new ArrayList<T>();
            this.lightsView = Collections.unmodifiableList(this.lights);
            this.removedLights = new HashSet<T>();
        }

        public LightData(LightTypeRegistry.LightType<?> type) {
            this(Objects.requireNonNull(type, "type").rendererFactory().createRenderer());
        }

        private void prepare(LightRenderer lightRenderer, CullFrustum frustum) {
            this.lights.removeAll(this.removedLights);
            this.renderer.prepareLights(lightRenderer, this.lights, this.removedLights, frustum);
            this.removedLights.clear();
        }

        private void render(LightRenderer lightRenderer) {
            this.renderer.renderLights(lightRenderer, this.lights);
        }

        private void addLight(Light light) {
            this.lights.add(light);
        }

        public void free() {
            this.renderer.free();
        }
    }
}

