/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.InstancedLight;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_291;
import net.minecraft.class_9801;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class InstancedLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final int MAX_UPLOADS = 400;
    protected final int lightSize;
    protected int maxLights;
    private final List<T> visibleLights;
    private final VertexArray vertexArray;
    private final int instancedVbo;
    private ByteBuffer scratch;

    public InstancedLightRenderer(int lightSize) {
        this.lightSize = lightSize;
        this.maxLights = 100;
        this.visibleLights = new ArrayList<T>();
        this.vertexArray = VertexArray.create();
        class_9801 mesh = this.createMesh();
        this.vertexArray.upload(mesh, VertexArray.DrawUsage.STATIC);
        this.instancedVbo = this.vertexArray.getOrCreateBuffer(2);
        if (VeilRenderSystem.directStateAccessSupported()) {
            GL45C.glNamedBufferData((int)this.instancedVbo, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
        } else {
            RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
            GL30C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
            RenderSystem.glBindBuffer((int)34962, (int)0);
        }
        VertexArrayBuilder builder = this.vertexArray.editFormat();
        builder.defineVertexBuffer(2, this.instancedVbo, 0, this.lightSize, 1);
        this.setupBufferState(builder);
    }

    protected abstract class_9801 createMesh();

    protected abstract void setupBufferState(VertexArrayBuilder var1);

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    protected abstract boolean isVisible(T var1, CullFrustum var2);

    private void updateAllLights(List<T> lights) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int pointer = 0;
            long offset = 0L;
            ByteBuffer dataBuffer = stack.malloc(Math.min(400, lights.size()) * this.lightSize);
            for (Light light : lights) {
                light.clean();
                dataBuffer.position(pointer++ * this.lightSize);
                ((InstancedLight)((Object)light)).store(dataBuffer);
                if (pointer < 400) continue;
                dataBuffer.rewind();
                GL30C.glBufferSubData((int)34962, (long)offset, (ByteBuffer)dataBuffer);
                offset += (long)dataBuffer.capacity();
                pointer = 0;
            }
            if (pointer > 0) {
                dataBuffer.rewind();
                GL30C.nglBufferSubData((int)34962, (long)offset, (long)((long)pointer * (long)this.lightSize), (long)MemoryUtil.memAddress((ByteBuffer)dataBuffer));
            }
        }
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        this.visibleLights.clear();
        for (Light light : lights) {
            if (!this.isVisible(light, frustum)) continue;
            this.visibleLights.add(light);
        }
        if (this.visibleLights.isEmpty()) {
            return;
        }
        RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
        boolean rebuild = false;
        if (this.visibleLights.size() > this.maxLights) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.ceil((double)this.maxLights / 2.0), (double)this.visibleLights.size() * 1.5);
            GL30C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35040);
        }
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(this.visibleLights);
        } else {
            this.scratch = GL30C.glMapBufferRange((int)34962, (long)0L, (long)((long)this.visibleLights.size() * (long)this.lightSize), (int)18, (ByteBuffer)this.scratch);
            for (int i = 0; i < this.visibleLights.size(); ++i) {
                Light light = (Light)this.visibleLights.get(i);
                if (!light.isDirty()) continue;
                if (this.scratch != null) {
                    this.scratch.position(i * this.lightSize);
                    light.clean();
                    ((InstancedLight)((Object)light)).store(this.scratch);
                }
                GL30C.glFlushMappedBufferRange((int)34962, (long)((long)i * (long)this.lightSize), (long)this.lightSize);
            }
            if (this.scratch != null) {
                this.scratch.rewind();
            }
            GL30C.glUnmapBuffer((int)34962);
        }
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights) {
        this.setupRenderState(lightRenderer, this.visibleLights);
        if (lightRenderer.applyShader()) {
            this.clearRenderState(lightRenderer, this.visibleLights);
            return;
        }
        this.vertexArray.bind();
        this.vertexArray.drawInstanced(this.visibleLights.size());
        class_291.method_1354();
        ShaderProgram.unbind();
        this.clearRenderState(lightRenderer, this.visibleLights);
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights.size();
    }

    public void free() {
        this.vertexArray.free();
    }
}

