/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light;

import foundry.veil.api.client.registry.LightTypeRegistry;
import net.minecraft.class_4184;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class Light
implements Cloneable {
    protected final Vector3f color = new Vector3f(1.0f);
    protected float brightness = 1.0f;
    private boolean dirty;

    public Light() {
        this.markDirty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clean() {
        this.dirty = false;
    }

    public Vector3fc getColor() {
        return this.color;
    }

    public int getColorInt() {
        int red = (int)(this.color.x() / 255.0f) & 0xFF;
        int green = (int)(this.color.y() / 255.0f) & 0xFF;
        int blue = (int)(this.color.z() / 255.0f) & 0xFF;
        return red << 16 | green << 8 | blue;
    }

    public Light setColor(Vector3fc color) {
        return this.setColor(color.x(), color.y(), color.z());
    }

    public Light setColor(float red, float green, float blue) {
        this.color.set(red, green, blue);
        this.markDirty();
        return this;
    }

    public Light setColor(int color) {
        this.color.set((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        this.markDirty();
        return this;
    }

    public Light setBrightness(float brightness) {
        this.brightness = brightness;
        this.markDirty();
        return this;
    }

    public Light setTo(class_4184 camera) {
        return this;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public abstract LightTypeRegistry.LightType<?> getType();
}

