/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboMutableTextureAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboRenderAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.render.texture.TextureFilter;
import foundry.veil.impl.client.render.framebuffer.AdvancedFboImpl;
import foundry.veil.impl.client.render.framebuffer.DSAAdvancedFboImpl;
import foundry.veil.impl.client.render.framebuffer.LegacyAdvancedFboImpl;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public interface AdvancedFbo
extends NativeResource {
    public void create();

    default public void clear() {
        this.clear(0.0f, 0.0f, 0.0f, 0.0f, this.getClearMask(), this.getDrawBuffers());
    }

    default public void clear(int buffers) {
        this.clear(0.0f, 0.0f, 0.0f, 0.0f, buffers, this.getDrawBuffers());
    }

    default public void clear(int buffers, int ... clearBuffers) {
        this.clear(0.0f, 0.0f, 0.0f, 0.0f, buffers, clearBuffers);
    }

    default public void clear(float red, float green, float blue, float alpha, int buffers) {
        this.clear(red, green, blue, alpha, buffers, this.getDrawBuffers());
    }

    public void clear(float var1, float var2, float var3, float var4, int var5, int ... var6);

    public void resetDrawBuffers();

    public void drawBuffers(int ... var1);

    public void bind(boolean var1);

    default public void bindRead() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36008, (int)this.getId());
    }

    public void bindDraw(boolean var1);

    public static AdvancedFbo getMainFramebuffer() {
        return AdvancedFboImpl.MAIN_WRAPPER.get();
    }

    public static void unbind() {
        class_276 mainTarget = class_310.method_1551().method_1522();
        if (mainTarget != null) {
            mainTarget.method_1235(true);
            return;
        }
        VeilRenderSystem.renderThreadExecutor().execute(() -> GlStateManager._glBindFramebuffer((int)36160, (int)0));
    }

    public static void unbindRead() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> GlStateManager._glBindFramebuffer((int)36008, (int)AdvancedFbo.getMainFramebuffer().getId()));
    }

    public static void unbindDraw() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> GlStateManager._glBindFramebuffer((int)36009, (int)AdvancedFbo.getMainFramebuffer().getId()));
    }

    public void resolveToFbo(int var1, int var2, int var3, int var4, int var5);

    default public void resolveToAdvancedFbo(AdvancedFbo target) {
        this.resolveToAdvancedFbo(target, 16640, 9728);
    }

    public void resolveToAdvancedFbo(AdvancedFbo var1, int var2, int var3);

    default public void resolveToRenderTarget(class_276 target) {
        this.resolveToRenderTarget(target, 16640, 9728);
    }

    public void resolveToRenderTarget(class_276 var1, int var2, int var3);

    default public void resolveToScreen() {
        this.resolveToAdvancedFbo(AdvancedFbo.getMainFramebuffer(), 16384, 9728);
    }

    default public void resolveToScreen(int mask, int filtering) {
        this.resolveToAdvancedFbo(AdvancedFbo.getMainFramebuffer(), mask, filtering);
    }

    public int getId();

    public int getWidth();

    public int getHeight();

    public int getColorAttachments();

    public int getClearMask();

    public int[] getDrawBuffers();

    public boolean hasColorAttachment(int var1);

    public boolean hasDepthAttachment();

    public boolean hasStencilAttachment();

    public AdvancedFboAttachment getColorAttachment(int var1);

    default public boolean isColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboTextureAttachment;
    }

    default public boolean isMutableColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboMutableTextureAttachment;
    }

    default public boolean isColorRenderAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboRenderAttachment;
    }

    default public AdvancedFboTextureAttachment getColorTextureAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a texture attachment to get texture information."), (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    default public void setColorAttachmentTexture(int attachment, int textureId) {
        this.setColorAttachmentTexture(attachment, textureId, -1);
    }

    default public void setColorAttachmentTexture(int attachment, int textureId, int layer) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isMutableColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a mutable texture attachment to modify texture information."), (Object[])new Object[0]);
        AdvancedFboMutableTextureAttachment mutableTextureAttachment = (AdvancedFboMutableTextureAttachment)advancedFboAttachment;
        mutableTextureAttachment.setTexture(textureId, layer);
        mutableTextureAttachment.attach(this, attachment);
    }

    default public AdvancedFboRenderAttachment getColorRenderAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorRenderAttachment(attachment), (String)("Color attachment " + attachment + " must be a render attachment to get render information."), (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    public AdvancedFboAttachment getDepthAttachment();

    default public boolean isDepthTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboTextureAttachment;
    }

    default public boolean isDepthMutableTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboMutableTextureAttachment;
    }

    default public boolean isDepthRenderAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboRenderAttachment;
    }

    default public AdvancedFboTextureAttachment getDepthTextureAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthTextureAttachment(), (String)"Depth attachment must be a texture attachment to get texture information.", (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    default public void setDepthAttachmentTexture(int textureId) {
        this.setDepthAttachmentTexture(textureId, -1);
    }

    default public void setDepthAttachmentTexture(int textureId, int layer) {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthMutableTextureAttachment(), (String)"Depth attachment must be a mutable texture attachment to modify texture information.", (Object[])new Object[0]);
        AdvancedFboMutableTextureAttachment mutableTextureAttachment = (AdvancedFboMutableTextureAttachment)advancedFboAttachment;
        mutableTextureAttachment.setTexture(textureId, layer);
        mutableTextureAttachment.attach(this, 0);
    }

    default public AdvancedFboRenderAttachment getDepthRenderAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthRenderAttachment(), (String)"Depth attachment must be a render attachment to get render information.", (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    @Nullable
    public String getDebugLabel();

    public class_276 toRenderTarget();

    public static Builder withSize(int width, int height) {
        return new Builder(width, height);
    }

    public static Builder copy(AdvancedFbo parent) {
        return new Builder(parent.getWidth(), parent.getHeight()).addAttachments(parent);
    }

    public static Builder copy(class_276 parent) {
        return AdvancedFboImpl.copy(parent);
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final List<AdvancedFboAttachment> colorAttachments;
        private AdvancedFboAttachment depthAttachment;
        private String debugLabel;
        private int levels;
        private int format;
        private int internalFormat;
        private boolean blur;
        private boolean mipmap;
        private float anisotropy;
        private TextureFilter.CompareFunction compareFunction;
        private TextureFilter.Wrap wrapS;
        private TextureFilter.Wrap wrapT;
        private int borderColor;
        private String name;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.colorAttachments = new LinkedList<AdvancedFboAttachment>();
            this.depthAttachment = null;
            this.debugLabel = null;
            this.reset();
        }

        private void setDefaultFormat(FramebufferAttachmentDefinition.Format format) {
            if (this.format == 0 && this.internalFormat == 0) {
                this.setFormat(format);
            }
        }

        private void reset() {
            this.levels = 1;
            this.format = 0;
            this.internalFormat = 0;
            this.blur = false;
            this.mipmap = false;
            this.anisotropy = 1.0f;
            this.compareFunction = null;
            this.wrapS = TextureFilter.Wrap.CLAMP_TO_EDGE;
            this.wrapT = TextureFilter.Wrap.CLAMP_TO_EDGE;
            this.borderColor = -16777216;
            this.name = null;
        }

        private void validateColorSize() {
            Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxColorAttachments(), (long)this.colorAttachments.size());
        }

        private void validateSamples() {
            int samples = -1;
            for (AdvancedFboAttachment attachment : this.colorAttachments) {
                if (!(attachment instanceof AdvancedFboRenderAttachment)) continue;
                if (samples == -1) {
                    samples = attachment.getLevels();
                    continue;
                }
                if (attachment.getLevels() == samples) continue;
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            if (samples != -1 && this.depthAttachment instanceof AdvancedFboRenderAttachment && this.depthAttachment.getLevels() != samples) {
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
        }

        private TextureFilter.EdgeType getEdgeType() {
            if (this.format == 36244 || this.format == 33320 || this.format == 36248 || this.format == 36249) {
                return TextureFilter.EdgeType.INT;
            }
            if (this.format == 34041) {
                return TextureFilter.EdgeType.UINT;
            }
            return TextureFilter.EdgeType.FLOAT;
        }

        public Builder addAttachments(AdvancedFbo parent) {
            for (int i = 0; i < parent.getColorAttachments(); ++i) {
                this.colorAttachments.add(parent.getColorAttachment(i).clone());
            }
            this.validateColorSize();
            if (parent.hasDepthAttachment()) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.depthAttachment = parent.getDepthAttachment().clone();
            }
            return this;
        }

        public Builder addAttachments(class_276 parent) {
            this.reset();
            this.addColorTextureBuffer(parent.field_1482, parent.field_1481);
            if (parent.field_1478) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.setDepthRenderBuffer(parent.field_1482, parent.field_1481);
            }
            return this;
        }

        public Builder setLevels(int levels) {
            this.levels = levels;
            return this;
        }

        public Builder setFormat(FramebufferAttachmentDefinition.Format format) {
            return this.setFormat(format.getFormat(), format.getInternalFormat());
        }

        public Builder setFormat(int format, int internalFormat) {
            this.format = format;
            this.internalFormat = internalFormat;
            return this;
        }

        public Builder setFilter(boolean blur, boolean mipmap) {
            this.blur = blur;
            this.mipmap = mipmap;
            return this;
        }

        public Builder setAnisotropy(float anisotropy) {
            this.anisotropy = anisotropy;
            return this;
        }

        public Builder setCompareFunction(@Nullable TextureFilter.CompareFunction compareFunction) {
            this.compareFunction = compareFunction;
            return this;
        }

        public Builder setWrapS(TextureFilter.Wrap wrapS) {
            this.wrapS = wrapS;
            return this;
        }

        public Builder setWrapS(int wrapS) {
            this.wrapS = (TextureFilter.Wrap)((Object)TextureFilter.Wrap.BY_GL_ID.getOrDefault(wrapS, (Object)TextureFilter.Wrap.CLAMP_TO_EDGE));
            return this;
        }

        public Builder setWrapT(TextureFilter.Wrap wrapT) {
            this.wrapT = wrapT;
            return this;
        }

        public Builder setWrapT(int wrapT) {
            this.wrapT = (TextureFilter.Wrap)((Object)TextureFilter.Wrap.BY_GL_ID.getOrDefault(wrapT, (Object)TextureFilter.Wrap.CLAMP_TO_EDGE));
            return this;
        }

        public Builder setWrap(TextureFilter.Wrap wrapS, TextureFilter.Wrap wrapT) {
            this.wrapS = wrapS;
            this.wrapT = wrapT;
            return this;
        }

        public Builder setWrap(int wrapS, int wrapT) {
            this.wrapS = (TextureFilter.Wrap)((Object)TextureFilter.Wrap.BY_GL_ID.getOrDefault(wrapS, (Object)TextureFilter.Wrap.CLAMP_TO_EDGE));
            this.wrapT = (TextureFilter.Wrap)((Object)TextureFilter.Wrap.BY_GL_ID.getOrDefault(wrapT, (Object)TextureFilter.Wrap.CLAMP_TO_EDGE));
            return this;
        }

        public Builder setBorderColor(int borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public Builder setFilter(TextureFilter filter) {
            this.setFilter(filter.blur(), filter.mipmap());
            this.setAnisotropy(filter.anisotropy());
            this.setCompareFunction(filter.compareFunction());
            this.setWrap(filter.wrapX(), filter.wrapY());
            this.setBorderColor(filter.borderColor());
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder addColorBuffer(AdvancedFboAttachment attachment) {
            this.colorAttachments.add(attachment);
            this.reset();
            this.validateColorSize();
            return this;
        }

        public Builder addColorTextureWrapper(int textureId) {
            return this.addColorTextureWrapper(textureId, -1);
        }

        public Builder addColorTextureWrapper(int textureId, int layer) {
            return this.addColorBuffer(new AdvancedFboMutableTextureAttachment(36064, textureId, layer, this.name));
        }

        public Builder addColorTextureBuffer() {
            return this.addColorTextureBuffer(this.width, this.height);
        }

        public Builder addColorTextureBuffer(int width, int height) {
            this.setDefaultFormat(FramebufferAttachmentDefinition.Format.RGBA8);
            Validate.isTrue((this.format != 6402 && this.format != 34041 ? 1 : 0) != 0, (String)"A color renderable format must be specified for color attachments", (Object[])new Object[0]);
            return this.addColorBuffer(new AdvancedFboTextureAttachment(36064, this.internalFormat, this.format, width, height, this.levels, new TextureFilter(this.blur, this.mipmap, this.anisotropy, this.compareFunction, this.wrapS, this.wrapT, TextureFilter.Wrap.CLAMP_TO_EDGE, this.borderColor, this.getEdgeType(), false), this.name));
        }

        public Builder addColorRenderBuffer() {
            return this.addColorRenderBuffer(this.width, this.height);
        }

        public Builder addColorRenderBuffer(int width, int height) {
            this.setDefaultFormat(FramebufferAttachmentDefinition.Format.RGBA8);
            Validate.isTrue((this.format != 6402 && this.format != 34041 ? 1 : 0) != 0, (String)"A color renderable format must be specified for color attachments", (Object[])new Object[0]);
            return this.addColorBuffer(new AdvancedFboRenderAttachment(36064, this.internalFormat, width, height, this.levels));
        }

        public Builder setDepthBuffer(@Nullable AdvancedFboAttachment attachment) {
            this.depthAttachment = attachment;
            this.reset();
            return this;
        }

        public Builder setDepthTextureWrapper(int textureId) {
            return this.setDepthTextureWrapper(textureId, -1);
        }

        public Builder setDepthTextureWrapper(int textureId, int layer) {
            return this.setDepthBuffer(new AdvancedFboMutableTextureAttachment(36096, textureId, layer, this.name));
        }

        public Builder setDepthTextureBuffer() {
            this.setDefaultFormat(FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT);
            return this.setDepthTextureBuffer(this.width, this.height);
        }

        public Builder setDepthTextureBuffer(int width, int height) {
            this.setDefaultFormat(FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT);
            Validate.isTrue((this.format == 6402 || this.format == 34041 ? 1 : 0) != 0, (String)"A depth or depth stencil format must be specified for depth attachments", (Object[])new Object[0]);
            return this.setDepthBuffer(new AdvancedFboTextureAttachment(this.format == 34041 ? 33306 : 36096, this.internalFormat, 6402, width, height, this.levels, new TextureFilter(this.blur, this.mipmap, this.anisotropy, this.compareFunction, this.wrapS, this.wrapT, TextureFilter.Wrap.CLAMP_TO_EDGE, this.borderColor, this.getEdgeType(), false), this.name));
        }

        public Builder setDepthRenderBuffer() {
            return this.setDepthRenderBuffer(this.width, this.height);
        }

        public Builder setDepthRenderBuffer(int width, int height) {
            this.setDefaultFormat(FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT);
            Validate.isTrue((this.format == 6402 || this.format == 34041 ? 1 : 0) != 0, (String)"A depth or depth stencil format must be specified for depth attachments", (Object[])new Object[0]);
            return this.setDepthBuffer(new AdvancedFboRenderAttachment(this.format == 34041 ? 33306 : 36096, this.internalFormat, width, height, this.levels));
        }

        public Builder setDebugLabel(@Nullable String debugLabel) {
            this.debugLabel = debugLabel;
            return this;
        }

        public AdvancedFbo build(boolean create) {
            AdvancedFboImpl framebuffer;
            if (this.colorAttachments.isEmpty()) {
                throw new IllegalArgumentException("Framebuffer needs at least one color attachment to be complete.");
            }
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalArgumentException("Framebuffer needs a positive area to be complete. (Was " + this.width + "x" + this.height + ")");
            }
            this.validateSamples();
            AdvancedFboImpl advancedFboImpl = framebuffer = VeilRenderSystem.directStateAccessSupported() ? new DSAAdvancedFboImpl(this.width, this.height, (AdvancedFboAttachment[])this.colorAttachments.toArray(AdvancedFboAttachment[]::new), this.depthAttachment, this.debugLabel) : new LegacyAdvancedFboImpl(this.width, this.height, (AdvancedFboAttachment[])this.colorAttachments.toArray(AdvancedFboAttachment[]::new), this.depthAttachment, this.debugLabel);
            if (create) {
                framebuffer.create();
            }
            return framebuffer;
        }
    }
}

