/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.animation.keyframe;

import foundry.veil.api.client.necromancer.Bone;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animation;
import foundry.veil.api.client.necromancer.animation.keyframe.Interpolation;
import foundry.veil.api.client.necromancer.animation.keyframe.Keyframe;
import foundry.veil.api.client.necromancer.animation.keyframe.KeyframeTimeline;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3532;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class KeyframedAnimation<P extends SkeletonParent<?, ?>, S extends Skeleton>
extends Animation<P, S> {
    private final Map<String, KeyframeTimeline> keyframesByBoneName;
    private final boolean additive;
    private final boolean looping;
    private final Quaternionf tempRotationA = new Quaternionf();
    private final Quaternionf tempRotationB = new Quaternionf();
    private final Keyframe[] tempKeyframes = new Keyframe[4];

    private KeyframedAnimation(Map<String, KeyframeTimeline> keyframesByBoneName, boolean additive, boolean looping) {
        this.keyframesByBoneName = keyframesByBoneName;
        this.additive = additive;
        this.looping = looping;
    }

    @Override
    public void apply(P parent, S skeleton, float mixFactor, float time) {
        for (Map.Entry<String, KeyframeTimeline> timeline : this.keyframesByBoneName.entrySet()) {
            Bone bone = ((Skeleton)skeleton).bones.get(timeline.getKey());
            if (bone == null) continue;
            KeyframeTimeline keyframes = timeline.getValue();
            float t = keyframes.getAdjacentKeyframes(time, this.looping, this.tempKeyframes);
            Keyframe a = this.tempKeyframes[1];
            Keyframe b = this.tempKeyframes[2];
            Interpolation interpolation = a.interpolation();
            if (this.additive) {
                bone.position.add(interpolation.interpolate(a.transform().px(), b.transform().px(), t), interpolation.interpolate(a.transform().py(), b.transform().py(), t), interpolation.interpolate(a.transform().pz(), b.transform().pz(), t));
                this.tempRotationA.set(a.transform().qx(), a.transform().qy(), a.transform().qz(), a.transform().qw());
                this.tempRotationB.set(b.transform().qx(), b.transform().qy(), b.transform().qz(), b.transform().qw());
                interpolation.interpolate((Quaternionfc)this.tempRotationA, (Quaternionfc)this.tempRotationB, t, this.tempRotationA);
                this.tempRotationA.slerp((Quaternionfc)this.tempRotationB.identity(), mixFactor);
                bone.rotation.premul((Quaternionfc)this.tempRotationA);
                bone.size.mul(class_3532.method_16439((float)mixFactor, (float)1.0f, (float)interpolation.interpolate(a.transform().sx(), b.transform().sx(), t)), class_3532.method_16439((float)mixFactor, (float)1.0f, (float)interpolation.interpolate(a.transform().sy(), b.transform().sy(), t)), class_3532.method_16439((float)mixFactor, (float)1.0f, (float)interpolation.interpolate(a.transform().sz(), b.transform().sz(), t)));
                continue;
            }
            bone.size.set(class_3532.method_16439((float)mixFactor, (float)bone.position.x, (float)interpolation.interpolate(a.transform().px(), b.transform().px(), t)), class_3532.method_16439((float)mixFactor, (float)bone.position.y, (float)interpolation.interpolate(a.transform().py(), b.transform().py(), t)), class_3532.method_16439((float)mixFactor, (float)bone.position.z, (float)interpolation.interpolate(a.transform().pz(), b.transform().pz(), t)));
            this.tempRotationA.set(a.transform().qx(), a.transform().qy(), a.transform().qz(), a.transform().qw());
            this.tempRotationB.set(b.transform().qx(), b.transform().qy(), b.transform().qz(), b.transform().qw());
            interpolation.interpolate((Quaternionfc)this.tempRotationA, (Quaternionfc)this.tempRotationB, t, this.tempRotationA);
            bone.rotation.slerp((Quaternionfc)this.tempRotationA, mixFactor);
            bone.size.set(class_3532.method_16439((float)mixFactor, (float)bone.size.x, (float)interpolation.interpolate(a.transform().sx(), b.transform().sx(), t)), class_3532.method_16439((float)mixFactor, (float)bone.size.y, (float)interpolation.interpolate(a.transform().sy(), b.transform().sy(), t)), class_3532.method_16439((float)mixFactor, (float)bone.size.z, (float)interpolation.interpolate(a.transform().sz(), b.transform().sz(), t)));
        }
    }

    public static class Builder {
        boolean looped = false;
        boolean additive = false;
        Map<String, List<Keyframe>> timelines = new HashMap<String, List<Keyframe>>();

        Builder looped(boolean isLooped) {
            this.looped = isLooped;
            return this;
        }

        Builder additive(boolean isAdditive) {
            this.additive = isAdditive;
            return this;
        }

        public void addKeyframe(String boneId, float time, Interpolation interpolation, Vector3fc position, Vector3fc size, Quaternionfc orientation) {
            if (!this.timelines.containsKey(boneId)) {
                this.timelines.put(boneId, new ArrayList(2));
            }
            this.timelines.get(boneId).add(new Keyframe(time, interpolation, new Keyframe.KeyframeTransform(position, size, orientation)));
        }

        public KeyframedAnimation<?, ?> build() {
            HashMap<String, KeyframeTimeline> builtTimelines = new HashMap<String, KeyframeTimeline>();
            for (Map.Entry<String, List<Keyframe>> timeline : this.timelines.entrySet()) {
                List<Keyframe> keyframeList = timeline.getValue();
                keyframeList.sort(Comparator.comparingDouble(Keyframe::time));
                KeyframeTimeline builtTimeline = new KeyframeTimeline(keyframeList.toArray(new Keyframe[0]));
                builtTimelines.put(timeline.getKey(), builtTimeline);
            }
            return new KeyframedAnimation(builtTimelines, this.additive, this.looped);
        }
    }
}

