package foundry.veil.impl.resource.action;

import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.type.BlockModelResource;
import java.util.OptionalInt;
import net.minecraft.class_2561;

public record ModelInspectAction<T extends BlockModelResource>() implements VeilResourceAction<T> {

    private static final class_2561 NAME = class_2561.method_43471("resource.veil.action.model_edit");
    private static final class_2561 DESC = class_2561.method_43471("resource.veil.action.model_edit.desc");

    @Override
    public class_2561 getName() {
        return NAME;
    }

    @Override
    public class_2561 getDescription() {
        return DESC;
    }

    @Override
    public OptionalInt getIcon() {
        return OptionalInt.of(0xECDB); // Edit file line icon
    }

    @Override
    public void perform(VeilEditorEnvironment environment, T resource) {
        environment.open(resource, VeilResourceEditorRegistry.BLOCK_MODEL.get());
    }
}
