package foundry.veil.impl.client.render.wrapper;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryStack;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_310;

import static org.lwjgl.opengl.ARBClearTexture.glClearTexImage;
import static org.lwjgl.opengl.ARBDirectStateAccess.*;
import static org.lwjgl.opengl.GL30C.*;

/**
 * Direct-state implementation of {@link VanillaAdvancedFboWrapper}.
 *
 * @author Ocelot
 */
@ApiStatus.Internal
public class DSAVanillaAdvancedFboWrapper extends VanillaAdvancedFboWrapper {

    public DSAVanillaAdvancedFboWrapper(Supplier<class_276> renderTargetSupplier) {
        super(renderTargetSupplier);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha, int clearMask, int... clearBuffers) {
        if (clearMask == 0) {
            return;
        }

        try (MemoryStack stack = MemoryStack.stackPush()) {
            boolean clearTex = VeilRenderSystem.clearTextureSupported();

            class_276 renderTarget = this.toRenderTarget();
            if ((clearMask & GL_COLOR_BUFFER_BIT) != 0) {
                if (clearTex) {
                    glClearTexImage(renderTarget.method_30277(), 0, GL_RGBA, GL_FLOAT, stack.floats(red, green, blue, alpha));
                } else {
                    glClearNamedFramebufferfv(renderTarget.method_30277(), GL_COLOR, 0, stack.floats(red, green, blue, alpha));
                }
            }

            if (renderTarget.field_1478) {
                boolean hasStencil = this.hasStencilAttachment();
                boolean depth = (clearMask & GL_DEPTH_BUFFER_BIT) != 0;
                boolean stencil = hasStencil && (clearMask & GL_STENCIL_BUFFER_BIT) != 0;
                if (!depth && !stencil) {
                    return;
                }

                if (hasStencil) {
                    if (depth && stencil) {
                        if (clearTex) {
                            glClearTexImage(renderTarget.method_30278(), 0, GL_DEPTH_STENCIL, GL_FLOAT_32_UNSIGNED_INT_24_8_REV, (ByteBuffer) null);
                        } else {
                            glClearNamedFramebufferfi(this.getId(), GL_DEPTH_STENCIL, 0, 1.0F, 0);
                        }
                    } else {
                        // Can't clear the texture if only clearing depth or stencil
                        if (depth) {
                            glClearNamedFramebufferfv(this.getId(), GL_DEPTH, 0, stack.floats(1.0F));
                        }
                        if (stencil) {
                            glClearNamedFramebufferiv(this.getId(), GL_STENCIL, 0, stack.ints(0));
                        }
                    }
                } else {
                    if (clearTex) {
                        glClearTexImage(renderTarget.method_30278(), 0, GL_DEPTH_COMPONENT, GL_FLOAT, stack.floats(1.0F));
                    } else {
                        glClearNamedFramebufferfv(this.getId(), GL_DEPTH, 0, stack.floats(1.0F));
                    }
                }
            }
        }

        if (class_310.field_1703) {
            glGetError();
        }
    }

    @Override
    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        glBlitNamedFramebuffer(this.getId(), id, 0, 0, this.getWidth(), this.getHeight(), 0, 0, width, height, mask, filtering);
    }

    @Override
    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        glBlitNamedFramebuffer(this.getId(), target.getId(), 0, 0, this.getWidth(), this.getHeight(), 0, 0, target.getWidth(), target.getHeight(), mask, filtering);
    }

    @Override
    public void resolveToRenderTarget(class_276 target, int mask, int filtering) {
        glBlitNamedFramebuffer(this.getId(), target.field_1476, 0, 0, this.getWidth(), this.getHeight(), 0, 0, target.field_1482, target.field_1481, mask, filtering);
    }
}
