package foundry.veil.fabric.mixin.client.perspective.vanilla;

import com.llamalad7.mixinextras.sugar.Local;
import foundry.veil.impl.client.render.perspective.LevelPerspectiveCamera;
import foundry.veil.impl.client.render.perspective.VeilSectionOcclusionGraph;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_769;
import net.minecraft.class_846;
import net.minecraft.class_9779;
import java.util.Objects;

@Mixin(class_761.class)
public abstract class LevelRendererMixin {

    @Shadow
    @Nullable
    private class_846 sectionRenderDispatcher;

    @Shadow
    @Final
    private class_310 minecraft;

    @Mutable
    @Shadow
    @Final
    private ObjectArrayList<class_846.class_851> visibleSections;

    @Shadow
    @Nullable
    private class_769 viewArea;

    @Unique
    private final VeilSectionOcclusionGraph veil$perspectiveOcclusionGraph = new VeilSectionOcclusionGraph();
    @Unique
    private final ObjectArrayList<class_846.class_851> veil$visibleSections = new ObjectArrayList<>(10000);
    @Unique
    private ObjectArrayList<class_846.class_851> veil$backupVisibleSections;

    @Inject(method = "setupRender", at = @At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", shift = At.Shift.AFTER, args = "ldc=camera"), cancellable = true)
    public void setupRender(class_4184 camera, class_4604 frustum, boolean hasCapturedFrustum, boolean isSpectator, CallbackInfo ci, @Local class_243 cameraPos) {
        if (!(camera instanceof LevelPerspectiveCamera perspectiveCamera)) {
            return;
        }

        ci.cancel();

        class_1297.method_5840(class_3532.method_15350(perspectiveCamera.getRenderDistance() / 8.0, 1.0, 2.5));
        this.sectionRenderDispatcher.method_19419(cameraPos);
        class_3695 profiler = this.minecraft.method_16011();
        profiler.method_15396("veil_section_occlusion_graph");
        this.veil$visibleSections.clear();
        this.veil$perspectiveOcclusionGraph.update(Objects.requireNonNull(this.viewArea), this.minecraft.field_1730, perspectiveCamera, frustum, this.veil$visibleSections);
        profiler.method_15407();
        profiler.method_15407();

        this.veil$backupVisibleSections = this.visibleSections;
        this.visibleSections = this.veil$visibleSections;
    }

    @Inject(method = "renderLevel", at = @At("TAIL"))
    public void resetSections(class_9779 deltaTracker, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (camera instanceof LevelPerspectiveCamera) {
            class_1297.method_5840(class_3532.method_15350((double) this.minecraft.field_1690.method_38521() / 8.0, 1.0, 2.5) * this.minecraft.field_1690.method_42517().method_41753());
            this.visibleSections = this.veil$backupVisibleSections;
            this.veil$visibleSections.clear();
        }
    }

    @Inject(method = "setLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/SectionOcclusionGraph;waitAndReset(Lnet/minecraft/client/renderer/ViewArea;)V"))
    public void resetSections(class_638 level, CallbackInfo ci) {
        this.veil$perspectiveOcclusionGraph.reset();
    }
}
