package foundry.veil.api.resource;

import foundry.veil.Veil;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import net.minecraft.class_2960;

/**
 * An environment where files can be opened, edited, and managed.
 */
public interface VeilEditorEnvironment {

    <T extends VeilResource<?>> void open(T resource, ResourceFileEditor.Factory<T> editor);

    @SuppressWarnings({"unchecked", "rawtypes"})
    default void open(VeilResource<?> resource, class_2960 editorName) {
        ResourceFileEditor.Factory factory = VeilResourceEditorRegistry.REGISTRY.method_10223(editorName);
        if (factory == null) {
            Veil.LOGGER.error("Failed to find editor for resource: {}", resource.resourceInfo().location());
            return;
        }

        this.open(resource, factory);
    }

    VeilResourceManager getResourceManager();
}
