package foundry.veil.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.mojang.datafixers.util.Either;
import foundry.veil.Veil;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;

@Deprecated
public class UIUtils {
    public static void drawHoverText(Tooltippable tooltippable, float pticks, final class_1799 stack, class_4587 pStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight,
                                     int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font,
                                     int tooltipTextWidthBonus, int tooltipTextHeightBonus, List<VeilUIItemTooltipDataHolder> items,
                                     int desiredX, int desiredY) {
        if (textLines.isEmpty()) {
            return;
        }

        List<class_5684> list = gatherTooltipComponents(stack, textLines, stack.method_32347().orElse(null), mouseX, screenWidth, screenHeight, font, font);
        // RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;

        for (class_5348 textLine : textLines) {
            int textLineWidth = font.method_27525(textLine);
            if (textLineWidth > tooltipTextWidth) {
                tooltipTextWidth = textLineWidth;
            }
        }

        boolean needsWrap = false;

        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth) {
            tooltipX = mouseX - 16 - tooltipTextWidth;
            if (tooltipX < 4) // if the tooltip doesn't fit on the screen
            {
                if (mouseX > screenWidth / 2) {
                    tooltipTextWidth = mouseX - 12 - 8;
                } else {
                    tooltipTextWidth = screenWidth - 16 - mouseX;
                }
                needsWrap = true;
            }
        }

        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }

        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            List<class_5348> wrappedTextLines = new ArrayList<>();
            for (int i = 0; i < textLines.size(); i++) {
                class_5348 textLine = textLines.get(i);
                List<class_5348> wrappedLine = font.method_27527()
                        .method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }

                for (class_5348 line : wrappedLine) {
                    int lineWidth = font.method_27525(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;

            if (mouseX > screenWidth / 2) {
                tooltipX = mouseX - 16 - tooltipTextWidth;
            } else {
                tooltipX = mouseX + 12;
            }
        }

        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;

        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2; // gap between title lines and next lines
            }
        }

        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }

        final int zLevel = 400;
        tooltipTextWidth += tooltipTextWidthBonus;
        tooltipHeight += tooltipTextHeightBonus;


//        VeilUITooltipRenderer.drawConnectionLine(pStack, tooltippable, tooltipX, tooltipY, desiredX, desiredY);
        drawTooltipRects(pticks, pStack, zLevel, backgroundColor, borderColorStart, borderColorEnd, font, list, tooltipTextWidth, titleLinesCount, tooltipX, tooltipY, tooltipHeight, items);
    }

    private static void drawTooltipRects(float pticks, class_4587 pStack, int z, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font, List<class_5684> list, int tooltipTextWidth, int titleLinesCount, int tooltipX, int tooltipY, int tooltipHeight, List<VeilUIItemTooltipDataHolder> items) {
        pStack.method_22903();
        Matrix4f mat = pStack.method_23760()
                .method_23761();
        drawGradientRect(mat, z, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        drawGradientRect(mat, z, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);

        int itemY = tooltipY;
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            if (lineNumber + 1 == titleLinesCount) {
                itemY += 2;
            }

            itemY += 10;
        }
        pStack.method_22903();
        pStack.method_46416(0, 0, 300);
        if (items != null && !items.isEmpty()) {
            for (VeilUIItemTooltipDataHolder item : items) {
                renderAndDecorateItem(item.getItemStack(), tooltipX + item.getX().apply(pticks), itemY + item.getY().apply(pticks));
                drawTexturedRect(pStack.method_23760().method_23761(), z + 100, tooltipX + item.getX().apply(pticks), itemY + item.getY().apply(pticks), 16, 16, 0, 0, 0, 0, 16, 16, Veil.veilPath("textures/gui/item_shadow.png"));
            }
        }
        pStack.method_22909();

        class_4597.class_4598 renderType = class_310.method_1551().method_22940().method_23000();
        pStack.method_22904(0.0D, 0.0D, z);

        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            class_5684 line = list.get(lineNumber);

            if (line != null) {
                line.method_32665(font, tooltipX, tooltipY, mat, renderType);
            }

            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }

            tooltipY += 10;
        }


        renderType.method_22993();
        pStack.method_22909();

        RenderSystem.enableDepthTest();
    }

    public static void renderAndDecorateItem(class_1799 $$0, float $$1, float $$2) {
        tryRenderGuiItem(class_310.method_1551().field_1724, $$0, $$1, $$2, 0);
    }

    public static void tryRenderGuiItem(@Nullable class_1309 $$0, class_1799 $$1, float $$2, float $$3, int $$4) {
        tryRenderGuiItem($$0, $$1, $$2, $$3, $$4, 0);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, @Nullable class_5632 itemComponent, int mouseX, int screenWidth, int screenHeight, @Nullable class_327 forcedFont, class_327 fallbackFont) {
        class_327 font = forcedFont != null ? forcedFont : fallbackFont;
        List<Either<class_5348, class_5632>> elements = textElements.stream()
                .map((Function<class_5348, Either<class_5348, class_5632>>) Either::left)
                .collect(Collectors.toCollection(ArrayList::new));
        if (itemComponent != null) {
            elements.add(1, Either.right(itemComponent));
        }

        // text wrapping
        int tooltipTextWidth = elements.stream()
                .mapToInt(either -> either.map(font::method_27525, component -> 0))
                .max()
                .orElse(0);

        boolean needsWrap = false;

        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth) {
            tooltipX = mouseX - 16 - tooltipTextWidth;
            if (tooltipX < 4) // if the tooltip doesn't fit on the screen
            {
                if (mouseX > screenWidth / 2) {
                    tooltipTextWidth = mouseX - 12 - 8;
                } else {
                    tooltipTextWidth = screenWidth - 16 - mouseX;
                }
                needsWrap = true;
            }
        }

//        if (tooltipTextWidth > -1)
//        {
//            tooltipTextWidth = -1;
//            needsWrap = true;
//        }

        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream()
                    .flatMap(either -> either.map(
                            text -> font.method_1728(text, tooltipTextWidthF).stream().map(class_5684::method_32662),
                            component -> Stream.of(class_5684.method_32663(component))
                    ))
                    .toList();
        }
        return elements.stream()
                .map(either -> either.map(
                        text -> class_5684.method_32662(text instanceof class_2561 ? ((class_2561) text).method_30937() : class_2477.method_10517().method_30934(text)),
                        class_5684::method_32663
                ))
                .toList();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float) (startColor >> 24 & 255) / 255.0F;
        float startRed = (float) (startColor >> 16 & 255) / 255.0F;
        float startGreen = (float) (startColor >> 8 & 255) / 255.0F;
        float startBlue = (float) (startColor & 255) / 255.0F;
        float endAlpha = (float) (endColor >> 24 & 255) / 255.0F;
        float endRed = (float) (endColor >> 16 & 255) / 255.0F;
        float endGreen = (float) (endColor >> 8 & 255) / 255.0F;
        float endBlue = (float) (endColor & 255) / 255.0F;

        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);

        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(mat, right, top, zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        buffer.method_22918(mat, left, top, zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        buffer.method_22918(mat, left, bottom, zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        buffer.method_22918(mat, right, bottom, zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        class_286.method_43433(buffer.method_60800());

        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(Matrix4f mat, int zLevel, float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, int textureWidth, int textureHeight, class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, texture);
        float f = 1.0F / textureWidth;
        float f1 = 1.0F / textureHeight;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(mat, x, y + height, zLevel).method_22913(u * f, (v + vHeight) * f1);
        buffer.method_22918(mat, x + width, y + height, zLevel).method_22913((u + uWidth) * f, (v + vHeight) * f1);
        buffer.method_22918(mat, x + width, y, zLevel).method_22913((u + uWidth) * f, v * f1);
        buffer.method_22918(mat, x, y, zLevel).method_22913(u * f, v * f1);
        class_286.method_43433(buffer.method_60800());
    }

    public static void tryRenderGuiItem(class_1309 $$0, class_1799 $$1, float $$2, float $$3, int $$4, float $$5) {
//        if (!$$1.isEmpty()) {
//            BakedModel $$6 = Minecraft.getInstance().getItemRenderer().getModel($$1, (Level) null, $$0, $$4);
//            Minecraft.getInstance().getItemRenderer().blitOffset = $$6.isGui3d() ? Minecraft.getInstance().getItemRenderer().blitOffset + 50.0F + (float) $$5 : Minecraft.getInstance().getItemRenderer().blitOffset + 50.0F;
//
//            try {
//                renderGuiItem($$1, $$2, $$3, $$6);
//            } catch (Throwable var11) {
//                CrashReport $$8 = CrashReport.forThrowable(var11, "Rendering item");
//                CrashReportCategory $$9 = $$8.addCategory("Item being rendered");
//                $$9.setDetail("Item Type", () -> {
//                    return String.valueOf($$1.getItem());
//                });
//                $$9.setDetail("Item Damage", () -> {
//                    return String.valueOf($$1.getDamageValue());
//                });
//                $$9.setDetail("Item NBT", () -> {
//                    return String.valueOf($$1.getTag());
//                });
//                $$9.setDetail("Item Foil", () -> {
//                    return String.valueOf($$1.hasFoil());
//                });
//                throw new ReportedException($$8);
//            }
//
//            Minecraft.getInstance().getItemRenderer().blitOffset = $$6.isGui3d() ? Minecraft.getInstance().getItemRenderer().blitOffset - 50.0F - (float) $$5 : Minecraft.getInstance().getItemRenderer().blitOffset - 50.0F;
//        }
    }
}
