package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_2350;
import net.minecraft.class_3300;

import static org.lwjgl.opengl.GL11C.*;
import static org.lwjgl.opengl.GL12C.*;
import static org.lwjgl.opengl.GL13C.GL_TEXTURE_CUBE_MAP;
import static org.lwjgl.opengl.GL13C.GL_TEXTURE_CUBE_MAP_POSITIVE_X;
import static org.lwjgl.opengl.GL14C.GL_TEXTURE_LOD_BIAS;

/**
 * Dynamic implementation of {@link CubemapTexture}. Must call {@link #init(int, int)} before it can be used.
 *
 * @author Ocelot
 */
public class DynamicCubemapTexture extends CubemapTexture {

    private final int[] width;
    private final int[] height;

    public DynamicCubemapTexture() {
        this.width = new int[6];
        this.height = new int[6];
    }

    private void init(int face, int width, int height) {
        this.width[face] = width;
        this.height[face] = height;
        RenderSystem.assertOnRenderThreadOrInit();
        glTexImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X + face, 0, GL_RGBA8, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0L);
    }

    /**
     * Initializes each face to the same size white texture.
     *
     * @param width  The width of each face
     * @param height The height of each face
     */
    public void init(int width, int height) {
        this.method_23207();
        this.method_4527(false, false);
        GlStateManager._texParameter(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MAX_LEVEL, 0);
        GlStateManager._texParameter(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MIN_LOD, 0);
        GlStateManager._texParameter(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MAX_LOD, 0);
        GlStateManager._texParameter(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_LOD_BIAS, 0.0F);

        RenderSystem.assertOnRenderThreadOrInit();
        for (int i = 0; i < 6; i++) {
            this.init(i, width, height);
        }
    }

    /**
     * Uploads the same image to all faces of the cubemap.
     *
     * @param image The image to upload
     */
    public void upload(class_1011 image) {
        this.init(image.method_4307(), image.method_4323());

        int width = image.method_4307();
        int height = image.method_4323();
        RenderSystem.assertOnRenderThreadOrInit();
        PipelineNativeImageAccessor accessor = (PipelineNativeImageAccessor) (Object) image;
        accessor.invokeCheckAllocated();
        GlStateManager._pixelStore(GL_UNPACK_ROW_LENGTH, 0);
        GlStateManager._pixelStore(GL_UNPACK_SKIP_ROWS, 0);
        GlStateManager._pixelStore(GL_UNPACK_SKIP_PIXELS, 0);
        class_1011.class_1012 format = image.method_4318();
        format.method_4340();
        for (int i = 0; i < 6; i++) {
            GlStateManager._texSubImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, 0, 0, width, height, format.method_4333(), GL_UNSIGNED_BYTE, accessor.getPixels());
        }
    }

    /**
     * Uploads the specified image to the specified face.
     *
     * @param face  The face to upload to
     * @param image The image to upload
     */
    public void upload(class_2350 face, class_1011 image) {
        this.upload(getGlFace(face), image);
    }

    /**
     * Uploads the specified image to the specified face.
     *
     * @param face  The face to upload to
     * @param image The image to upload
     */
    public void upload(int face, class_1011 image) {
        if (this.field_5204 == -1) {
            this.init(image.method_4307(), image.method_4323());
        } else if (this.width[face - GL_TEXTURE_CUBE_MAP_POSITIVE_X] != image.method_4307() || this.height[face - GL_TEXTURE_CUBE_MAP_POSITIVE_X] != image.method_4323()) {
            this.init(face, image.method_4307(), image.method_4323());
        } else {
            this.method_23207();
        }

        int width = image.method_4307();
        int height = image.method_4323();
        RenderSystem.assertOnRenderThreadOrInit();
        PipelineNativeImageAccessor accessor = (PipelineNativeImageAccessor) (Object) image;
        accessor.invokeCheckAllocated();
        GlStateManager._pixelStore(GL_UNPACK_ROW_LENGTH, 0);
        GlStateManager._pixelStore(GL_UNPACK_SKIP_ROWS, 0);
        GlStateManager._pixelStore(GL_UNPACK_SKIP_PIXELS, 0);
        class_1011.class_1012 format = image.method_4318();
        format.method_4340();
        GlStateManager._texSubImage2D(face, 0, 0, 0, width, height, format.method_4333(), GL_UNSIGNED_BYTE, accessor.getPixels());
    }

    @Override
    public void method_4625(class_3300 resourceManager) throws IOException {
    }
}
