package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import net.minecraft.class_1044;
import net.minecraft.class_2350;

import static org.lwjgl.opengl.ARBDirectStateAccess.glTextureParameteri;
import static org.lwjgl.opengl.GL11C.*;
import static org.lwjgl.opengl.GL13C.*;

/**
 * {@link class_1044} implementation for using a cubemap texture.
 *
 * @author Ocelot
 */
public abstract class CubemapTexture extends class_1044 {

    /**
     * Converts the {@link class_2350} value to the correct GL cubemap enum.
     *
     * @param direction The direction to convert
     * @return The OpenGL enum
     */
    public static int getGlFace(class_2350 direction) {
        return switch (direction) {
            case field_11033 -> GL_TEXTURE_CUBE_MAP_NEGATIVE_Y;
            case field_11036 -> GL_TEXTURE_CUBE_MAP_POSITIVE_Y;
            case field_11043 -> GL_TEXTURE_CUBE_MAP_NEGATIVE_Z;
            case field_11035 -> GL_TEXTURE_CUBE_MAP_POSITIVE_Z;
            case field_11039 -> GL_TEXTURE_CUBE_MAP_NEGATIVE_X;
            case field_11034 -> GL_TEXTURE_CUBE_MAP_POSITIVE_X;
        };
    }

    @Override
    public void method_4527(boolean blur, boolean mipmap) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.field_5205 = blur;
        this.field_5203 = mipmap;
        int minFilter;
        int magFilter;
        if (blur) {
            minFilter = mipmap ? GL_LINEAR_MIPMAP_LINEAR : GL_LINEAR;
            magFilter = GL_LINEAR;
        } else {
            minFilter = mipmap ? GL_NEAREST_MIPMAP_LINEAR : GL_NEAREST;
            magFilter = GL_NEAREST;
        }

        if (VeilRenderSystem.directStateAccessSupported()) {
            int id = this.method_4624();
            glTextureParameteri(id, GL_TEXTURE_MIN_FILTER, minFilter);
            glTextureParameteri(id, GL_TEXTURE_MAG_FILTER, magFilter);
        } else {
            this.method_23207();
            glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MIN_FILTER, minFilter);
            glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MAG_FILTER, magFilter);
        }
    }

    @Override
    public int method_4624() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.field_5204 == -1) {
            this.field_5204 = VeilRenderSystem.createTextures(GL_TEXTURE_CUBE_MAP);
        }

        return this.field_5204;
    }

    @Override
    public void method_23207() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> glBindTexture(GL_TEXTURE_CUBE_MAP, this.method_4624()));
    }
}
