package foundry.veil.api.client.render.rendertype;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL14C;

import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_765;

/**
 * Provides access to the individual shards of a {@link class_1921}.
 *
 * @author Ocelot
 */
public interface VeilRenderTypeAccessor {

    /**
     * @return The Minecraft state deciding what textures should be bound
     */
    class_4668.class_5939 textureState();

    /**
     * @return The Minecraft state deciding what {@link class_5944} to use
     */
    class_4668.class_5942 shaderState();

    /**
     * @return The state of {@link GL14C#glBlendFuncSeparate(int, int, int, int)}
     */
    class_4668.class_4685 transparencyState();

    /**
     * @return The state of {@link GL11C#GL_DEPTH_TEST}
     */
    class_4668.class_4672 depthTestState();

    /**
     * @return The state of {@link GL11C#glCullFace(int)}
     */
    class_4668.class_4671 cullState();

    /**
     * @return The Minecraft state determining if the {@link class_765} should be enabled
     */
    class_4668.class_4676 lightmapState();

    /**
     * @return The Minecraft state determining if the {@link class_4608} should be enabled
     */
    class_4668.class_4679 overlayState();

    /**
     * @return The state of {@link GL11C#glPolygonOffset(float, float)} or {@link RenderSystem#getModelViewStack()}
     */
    class_4668.class_4675 layeringState();

    /**
     * @return The state of what framebuffer to write into
     */
    class_4668.class_4678 outputState();

    /**
     * @return The Minecraft state intended to call {@link RenderSystem#setTextureMatrix(Matrix4f)}
     */
    class_4668.class_4684 texturingState();

    /**
     * @return The state of {@link GL11C#glColorMask(boolean, boolean, boolean, boolean)} and {@link GL11C#glDepthMask(boolean)}
     */
    class_4668.class_4686 writeMaskState();

    /**
     * @return The state of {@link GL11C#glLineWidth(float)}
     */
    class_4668.class_4677 lineState();

    /**
     * @return The state of {@link GL11C#glLogicOp(int)}
     */
    class_4668.class_8559 colorLogicState();

    /**
     * @return The outline property state
     */
    class_1921.class_4750 outlineProperty();

    /**
     * @return An immutable view of all states in the render type
     */
    List<class_4668> states();
}
