package foundry.veil.mixin.quasar.client;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.impl.quasar.QuasarParticleHandler;
import net.minecraft.class_638;
import net.minecraft.class_702;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_702.class)
public class QuasarParticleEngineMixin {

    @Inject(method = "tick", at=@At("HEAD"))
    public void tick(CallbackInfo ci){
        VeilRenderSystem.renderer().getParticleManager().tick();
    }

    @Inject(method = "countParticles", at = @At("RETURN"), cancellable = true)
    public void countParticles(CallbackInfoReturnable<String> cir) {
        ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
        cir.setReturnValue(cir.getReturnValue() + ". VE: " + particleManager.getEmitterCount() + ". VP: " + particleManager.getParticleCount());
    }

    @Inject(method = "setLevel", at = @At("HEAD"))
    public void setLevel(@Nullable class_638 level, CallbackInfo ci) {
        QuasarParticleHandler.setLevel(level);
    }

    @Inject(method = "clearParticles", at = @At("TAIL"))
    public void clear(CallbackInfo ci) {
        QuasarParticleHandler.free();
    }
}
