package foundry.veil.mixin.pipeline.client;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.texture.VeilPreloadedTexture;
import foundry.veil.ext.TextureManagerExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

@Mixin(class_1060.class)
public abstract class PipelineTextureManagerMixin implements TextureManagerExtension {

    @Shadow
    @Final
    private Map<class_2960, class_1044> byPath;

    @Shadow
    @Final
    private class_3300 resourceManager;

    @Shadow
    public abstract void register(class_2960 path, class_1044 texture);

    @Override
    public <T extends class_1044 & VeilPreloadedTexture> CompletableFuture<?> veil$registerPreloadedTexture(class_2960 path, T texture, Executor executor) {
        if (!this.byPath.containsKey(path)) {
            this.byPath.put(path, texture);
            return texture.preload(this.resourceManager, executor).thenRunAsync(() -> this.register(path, texture), command -> class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(command::run)));
        } else {
            return CompletableFuture.completedFuture(null);
        }
    }
}
