package foundry.veil.mixin.pipeline.client;

import foundry.veil.api.client.render.MatrixStack;
import org.joml.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.Deque;
import net.minecraft.class_4587;

@Mixin(class_4587.class)
public abstract class PipelinePoseStackMixin implements MatrixStack {

    @Unique
    private static final Matrix3f veil$IDENTITY_NORMAL = new Matrix3f();

    @Shadow
    public abstract void shadow$scale(float x, float y, float z);

    @Shadow
    public abstract void shadow$mulPose(Quaternionf quaternion);

    @Shadow
    public abstract void shadow$rotateAround(Quaternionf quaternion, float x, float y, float z);

    @Shadow
    public abstract void shadow$pushPose();

    @Shadow
    public abstract void shadow$popPose();

    @Shadow
    @Final
    private Deque<class_4587.class_4665> poseStack;

    @Shadow
    public abstract class_4587.class_4665 last();

    @Unique
    private final Quaternionf veil$castQuat = new Quaternionf();

    @Override
    public void clear() {
        while (this.poseStack.size() > 1) {
            this.shadow$popPose();
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        this.pose().method_23761().translate(x, y, z);
    }

    @Override
    public void rotate(Quaterniondc rotation) {
        this.shadow$mulPose(this.veil$castQuat.set(rotation));
    }

    @Override
    public void rotate(Quaternionfc rotation) {
        this.shadow$mulPose(this.veil$castQuat.set(rotation));
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateAxis(angle, x, y, z));
    }

    @Override
    public void rotateXYZ(float x, float y, float z) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateXYZ(x, y, z));
    }

    @Override
    public void rotateZYX(float z, float y, float x) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateZYX(z, y, x));
    }

    @Override
    public void rotateAround(Quaterniondc rotation, double x, double y, double z) {
        this.shadow$rotateAround(this.veil$castQuat.set(rotation), (float) x, (float) y, (float) z);
    }

    @Override
    public void rotateAround(Quaternionfc rotation, float x, float y, float z) {
        this.shadow$rotateAround(this.veil$castQuat.set(rotation), x, y, z);
    }

    @Override
    public void applyScale(float x, float y, float z) {
        this.shadow$scale(x, y, z);
    }

    @Override
    public boolean isIdentity() {
        class_4587.class_4665 pose = this.pose();
        return (pose.method_23761().properties() & Matrix4fc.PROPERTY_IDENTITY) != 0 && pose.method_23762().equals(veil$IDENTITY_NORMAL);
    }

    @Override
    public boolean isEmpty() {
        return this.poseStack.size() == 1;
    }

    @Override
    public void matrixPush() {
        this.shadow$pushPose();
    }

    @Override
    public void matrixPop() {
        this.shadow$popPose();
    }

    @Override
    public class_4587.class_4665 pose() {
        return this.poseStack.getLast();
    }

    @Override
    public class_4587 toPoseStack() {
        return (class_4587) (Object) this;
    }
}
