package foundry.veil.mixin.pipeline.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4604;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_846;

@Mixin(class_761.class)
public abstract class PipelineLevelRendererMixin implements LevelRendererExtension {

    @Shadow
    private class_4604 cullingFrustum;

    @Shadow
    @Nullable
    private class_4604 capturedFrustum;

    @Shadow
    private @Nullable class_279 transparencyChain;

    @Shadow
    private @Nullable class_276 translucentTarget;

    @Shadow
    private @Nullable class_276 itemEntityTarget;

    @Shadow
    private @Nullable class_276 particlesTarget;

    @Shadow
    private @Nullable class_276 weatherTarget;

    @Shadow
    private @Nullable class_276 cloudsTarget;

    @Shadow
    @Final
    private ObjectArrayList<class_846.class_851> visibleSections;

    @Shadow
    @Final
    private class_310 minecraft;

    @Shadow
    protected abstract void renderSectionLayer(class_1921 pRenderType, double pX, double pY, double pZ, Matrix4f pFrustrumMatrix, Matrix4f pProjectionMatrix);

    @Unique
    private final Matrix4f veil$tempFrustum = new Matrix4f();
    @Unique
    private final Matrix4f veil$tempProjection = new Matrix4f();

    @Inject(method = "renderLevel", at=@At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args = "ldc=entities"))
    public void saveFramebuffer(CallbackInfo ci){
        FramebufferStack.push(null);
    }

    @Inject(method = "renderLevel", at=@At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;getModelViewStack()Lorg/joml/Matrix4fStack;"), remap = false)
    public void loadFramebuffer(CallbackInfo ci){
        FramebufferStack.pop(null);
    }

    @Inject(method = "prepareCullFrustum", at = @At("HEAD"))
    public void veil$setupLevelCamera(class_243 pos, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        VeilRenderSystem.renderer().getCameraMatrices().update(projectionMatrix, frustumMatrix, pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    @Inject(method = "renderLevel", at = @At("TAIL"))
    public void blit(CallbackInfo ci, @Local class_3695 profiler) {
        if (!VeilLevelPerspectiveRenderer.isRenderingPerspective()) {
            if (VeilRenderSystem.drawLights(profiler, VeilRenderSystem.getCullingFrustum())) {
                VeilRenderSystem.compositeLights(profiler);
            } else {
                AdvancedFbo.unbind();
            }
        }
    }

    // This sets the blend function for rain correctly
    @Inject(method = "renderLevel", at = @At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args = "ldc=weather"))
    public void setRainBlend(CallbackInfo ci) {
        RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    // Add custom world border shader
    @ModifyArg(method = "renderWorldBorder", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShader(Ljava/util/function/Supplier;)V", remap = false))
    public Supplier<class_5944> setWorldBorderShader(Supplier<class_5944> supplier) {
        return VeilVanillaShaders::getWorldborder;
    }

    @Inject(method = "deinitTransparency", at = @At("RETURN"))
    public void deinitTransparency(CallbackInfo ci) {
        FramebufferManager framebufferManager = VeilRenderSystem.renderer().getFramebufferManager();
        framebufferManager.removeFramebuffer(VeilFramebuffers.TRANSLUCENT_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.ITEM_ENTITY_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.PARTICLES_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.WEATHER_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.CLOUDS_TARGET);
    }

    @Inject(method = "initTransparency", at = @At("RETURN"))
    public void initTransparency(CallbackInfo ci) {
        if (this.transparencyChain == null) {
            return;
        }

        FramebufferManager framebufferManager = VeilRenderSystem.renderer().getFramebufferManager();
        framebufferManager.setFramebuffer(VeilFramebuffers.TRANSLUCENT_TARGET, VeilRenderBridge.wrap(this.translucentTarget));
        framebufferManager.setFramebuffer(VeilFramebuffers.ITEM_ENTITY_TARGET, VeilRenderBridge.wrap(this.itemEntityTarget));
        framebufferManager.setFramebuffer(VeilFramebuffers.PARTICLES_TARGET, VeilRenderBridge.wrap(this.particlesTarget));
        framebufferManager.setFramebuffer(VeilFramebuffers.WEATHER_TARGET, VeilRenderBridge.wrap(this.weatherTarget));
        framebufferManager.setFramebuffer(VeilFramebuffers.CLOUDS_TARGET, VeilRenderBridge.wrap(this.cloudsTarget));
    }

    @Inject(method = "setLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/SectionOcclusionGraph;waitAndReset(Lnet/minecraft/client/renderer/ViewArea;)V"))
    public void free(class_638 level, CallbackInfo ci) {
        VeilRenderSystem.clearLevel();
    }

    @Override
    public CullFrustum veil$getCullFrustum() {
        return VeilRenderBridge.create(this.capturedFrustum != null ? this.capturedFrustum : this.cullingFrustum);
    }

    @Override
    public void veil$drawBlockLayer(class_1921 renderType, double x, double y, double z, Matrix4fc frustum, Matrix4fc projection) {
        RenderSystem.assertOnRenderThread();

        if (renderType instanceof VeilRenderType.LayeredRenderType layeredRenderType) {
            class_3695 profiler = this.minecraft.method_16011();

            this.veil$tempFrustum.set(frustum);
            this.veil$tempProjection.set(projection);
            class_1041 window = this.minecraft.method_22683();

            List<class_1921> layers = layeredRenderType.getLayers();
            boolean rendered = false;

            profiler.method_15396("render_" + VeilRenderType.getName(renderType));
            boolean forward = !renderType.method_60894();
            ObjectListIterator<class_846.class_851> objectlistiterator = this.visibleSections.listIterator(forward ? 0 : this.visibleSections.size());

            class_5944 shaderInstance = null;
            class_284 chunkOffset = null;

            ObjectList<class_846.class_851> validSections = new ObjectArrayList<>(this.visibleSections.size());
            ObjectList<class_291> buffers = new ObjectArrayList<>(this.visibleSections.size());
            while (true) {
                if (forward) {
                    if (!objectlistiterator.hasNext()) {
                        break;
                    }
                } else if (!objectlistiterator.hasPrevious()) {
                    break;
                }

                class_846.class_851 section = forward ? objectlistiterator.next() : objectlistiterator.previous();
                if (!section.method_3677().method_3641(renderType)) {
                    // Don't set up the render state until something is actually rendered
                    if (!rendered) {
                        renderType.method_23516();
                        shaderInstance = RenderSystem.getShader();
                        if (shaderInstance != null) {
                            shaderInstance.method_60897(class_293.class_5596.field_27382, this.veil$tempFrustum, this.veil$tempProjection, window);
                            shaderInstance.method_34586();
                            chunkOffset = shaderInstance.field_29482;
                        }
                        rendered = true;
                    }

                    if (chunkOffset != null) {
                        class_2338 origin = section.method_3670();
                        chunkOffset.method_1249((float) (origin.method_10263() - x), (float) (origin.method_10264() - y), (float) (origin.method_10260() - z));
                        chunkOffset.method_1300();
                    }

                    class_291 vertexbuffer = section.method_3656(renderType);
                    vertexbuffer.method_1353();
                    vertexbuffer.method_35665();

                    // Keep track of valid sections, so we can loop immediately after
                    validSections.add(section);
                    buffers.add(vertexbuffer);
                }
            }

            if (!rendered) {
                profiler.method_15407();
                return;
            }

            if (chunkOffset != null) {
                chunkOffset.method_1249(0.0F, 0.0F, 0.0F);
            }
            if (shaderInstance != null) {
                shaderInstance.method_34585();
            }
            renderType.method_23518();
            profiler.method_15407();

            if (!validSections.isEmpty()) {
                // Loop again to draw each layer, making sure not to loop through EVERY section
                for (class_1921 layer : layers) {
                    layer.method_23516();
                    profiler.method_15396("render_" + VeilRenderType.getName(layers.getFirst()));
                    shaderInstance = RenderSystem.getShader();
                    if (shaderInstance != null) {
                        shaderInstance.method_60897(class_293.class_5596.field_27382, this.veil$tempFrustum, this.veil$tempProjection, window);
                        shaderInstance.method_34586();
                        chunkOffset = shaderInstance.field_29482;
                    }

                    for (int j = 0; j < validSections.size(); j++) {
                        class_846.class_851 section = validSections.get(j);
                        class_291 vertexbuffer = buffers.get(j);

                        if (chunkOffset != null) {
                            class_2338 origin = section.method_3670();
                            chunkOffset.method_1249((float) (origin.method_10263() - x), (float) (origin.method_10264() - y), (float) (origin.method_10260() - z));
                            chunkOffset.method_1300();
                        }

                        vertexbuffer.method_1353();
                        vertexbuffer.method_35665();
                    }

                    if (chunkOffset != null) {
                        chunkOffset.method_1249(0.0F, 0.0F, 0.0F);
                    }
                    if (shaderInstance != null) {
                        shaderInstance.method_34585();
                    }
                    profiler.method_15407();
                    layer.method_23518();
                }
            }

            class_291.method_1354();
        } else {
            this.renderSectionLayer(renderType, x, y, z, this.veil$tempFrustum.set(frustum), this.veil$tempProjection.set(projection));
        }
    }

    @Override
    public void veil$markChunksDirty() {
        SodiumCompat sodiumCompat = SodiumCompat.INSTANCE;

        if (sodiumCompat != null) {
            sodiumCompat.markChunksDirty();
        } else {
            for (class_846.class_851 section : this.visibleSections) {
                section.method_3654(false);
            }
        }
    }
}