package foundry.veil.mixin.performance.client;

import foundry.veil.ext.PerformanceRenderTargetExtension;
import net.minecraft.class_276;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_761.class)
public class PerformanceLevelRendererMixin {

    @Redirect(method = "renderLevel", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/pipeline/RenderTarget;clear(Z)V", ordinal = 0))
    public void clearItemEntityColor(class_276 instance, boolean clearError) {
        ((PerformanceRenderTargetExtension) instance).veil$clearColorBuffer(clearError);
    }

    @Redirect(method = "renderLevel", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/pipeline/RenderTarget;clear(Z)V", ordinal = 3))
    public void clearTranslucentColor(class_276 instance, boolean clearError) {
        ((PerformanceRenderTargetExtension) instance).veil$clearColorBuffer(clearError);
    }

    @Redirect(method = "renderLevel", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/pipeline/RenderTarget;clear(Z)V", ordinal = 4))
    public void clearParticlesColor(class_276 instance, boolean clearError) {
        ((PerformanceRenderTargetExtension) instance).veil$clearColorBuffer(clearError);
    }
}
