package foundry.veil.mixin.debug.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static org.lwjgl.glfw.GLFW.GLFW_KEY_L;
import static org.lwjgl.glfw.GLFW.GLFW_KEY_Q;

import net.minecraft.class_2561;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_338;

@Mixin(class_309.class)
public abstract class DebugKeyboardHandlerMixin {

    @Shadow
    @Final
    private class_310 minecraft;

    @Shadow
    protected abstract boolean handleChunkDebugKeys(int key);

    @Inject(method = "handleDebugKeys", at = @At("HEAD"), cancellable = true)
    public void handleChunkDebugKeys(int key, CallbackInfoReturnable<Boolean> cir) {
        if (key != GLFW_KEY_L && this.handleChunkDebugKeys(key)) {
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "handleDebugKeys", at = @At("RETURN"))
    public void printChunkDebugKeys(int key, CallbackInfoReturnable<Boolean> cir) {
        if (key == GLFW_KEY_Q) {
            class_338 $$3 = this.minecraft.field_1705.method_1743();
            $$3.method_1812(class_2561.method_43470("F3 + E = Show VisGraph Path"));
            $$3.method_1812(class_2561.method_43470("F3 + U = Capture View Frustum"));
            $$3.method_1812(class_2561.method_43470("F3 + Shift + U = Kill Captured View Frustum"));
            $$3.method_1812(class_2561.method_43470("F3 + V = Show VisGraph Visibility"));
            $$3.method_1812(class_2561.method_43470("F3 + W = Show Wireframe"));
        }
    }
}
