package foundry.veil.impl.client.render.vertex;

import foundry.veil.api.client.render.vertex.VertexArray;
import org.jetbrains.annotations.ApiStatus;

import java.nio.ByteBuffer;
import net.minecraft.class_9801;

import static org.lwjgl.opengl.GL15C.*;

@ApiStatus.Internal
public class LegacyVertexArray extends VertexArray {

    public LegacyVertexArray(int id) {
        super(id, LegacyVertexAttribBindingBuilder::new);
    }

    @Override
    public void upload(int attributeStart, class_9801 meshData, DrawUsage usage) {
        int old = glGetInteger(GL_ARRAY_BUFFER_BINDING);
        try {
            super.upload(attributeStart, meshData, usage);
        } finally {
            glBindBuffer(GL_ARRAY_BUFFER, old);
        }
    }

    @Override
    protected int createBuffer() {
        return glGenBuffers();
    }

    @Override
    protected void uploadVertexBuffer(int buffer, ByteBuffer data, int usage) {
        glBindBuffer(GL_ARRAY_BUFFER, buffer);
        glBufferData(GL_ARRAY_BUFFER, data, usage);
    }
}
