package foundry.veil.impl.client.render.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.mixin.pipeline.accessor.PipelineAutoStorageIndexBufferAccessor;
import org.jetbrains.annotations.ApiStatus;

import java.nio.ByteBuffer;
import net.minecraft.class_9801;

import static org.lwjgl.opengl.ARBDirectStateAccess.*;
import static org.lwjgl.opengl.GL15C.GL_STATIC_DRAW;

@ApiStatus.Internal
public class DSAVertexAttribBindingVertexArray extends VertexArray {

    public DSAVertexAttribBindingVertexArray(int id) {
        super(id, vao -> new DSAVertexAttribBindingBuilder(vao, id));
    }

    @Override
    public void uploadIndexBuffer(ByteBuffer data) {
        int elementArrayBuffer = this.getOrCreateBuffer(ELEMENT_ARRAY_BUFFER);
        glNamedBufferData(elementArrayBuffer, data, GL_STATIC_DRAW);
        glVertexArrayElementBuffer(this.id, elementArrayBuffer);
    }

    @Override
    public void uploadIndexBuffer(class_9801.class_4574 drawState) {
        super.uploadIndexBuffer(drawState);
        PipelineAutoStorageIndexBufferAccessor ext = (PipelineAutoStorageIndexBufferAccessor) (Object) RenderSystem.getSequentialBuffer(drawState.comp_752());
        glVertexArrayElementBuffer(this.id, ext.getName());
    }

    @Override
    protected int createBuffer() {
        return glCreateBuffers();
    }

    @Override
    protected void uploadVertexBuffer(int buffer, ByteBuffer data, int usage) {
        glNamedBufferData(buffer, data, usage);
    }
}
