package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.PointLight;
import foundry.veil.api.client.render.light.renderer.IndirectLightRenderer;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_9801;

@ApiStatus.Internal
public class IndirectPointLightRenderer extends IndirectLightRenderer<PointLight> {

    private static final class_2960 SHADER = Veil.veilPath("light/point");

    public IndirectPointLightRenderer() {
        super(Float.BYTES * 7, 4, 0, 6);
    }

    @Override
    protected class_9801 createMesh() {
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1592);

        // High-res mesh
        LightTypeRenderer.createInvertedCube(bufferBuilder);

        // Low-res mesh
        float sqrt2 = (float) Math.sqrt(2.0);
        bufferBuilder.method_22912(-sqrt2, -sqrt2, 0);
        bufferBuilder.method_22912(sqrt2, -sqrt2, 0);
        bufferBuilder.method_22912(-sqrt2, sqrt2, 0);
        bufferBuilder.method_22912(sqrt2, sqrt2, 0);

        return bufferBuilder.method_60800();
    }

    @Override
    protected void setupBufferState(VertexArrayBuilder builder) {
        builder.setVertexAttribute(1, 2, 3, VertexArrayBuilder.DataType.FLOAT, false, 0);
        builder.setVertexAttribute(2, 2, 3, VertexArrayBuilder.DataType.FLOAT, false, Float.BYTES * 3);
        builder.setVertexAttribute(3, 2, 1, VertexArrayBuilder.DataType.FLOAT, false, Float.BYTES * 6);
    }

    @Override
    protected void setupRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<PointLight> lights) {
        VeilRenderSystem.setShader(SHADER);
    }

    @Override
    protected void clearRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<PointLight> lights) {
    }
}
