package foundry.veil.impl.client.render.dynamicbuffer;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import org.jetbrains.annotations.ApiStatus;

import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_4668;

@ApiStatus.Internal
public class DynamicBufferShard extends class_4668 {

    public DynamicBufferShard(String name, Supplier<class_276> targetSupplier) {
        this(Veil.veilPath("dynamic_" + name), targetSupplier);
    }

    public DynamicBufferShard(class_2960 name, Supplier<class_276> targetSupplier) {
        super(Veil.MODID + ":dynamic_buffer", () -> {
            if (!Veil.platform().hasErrors()) {
                if (!VeilLevelPerspectiveRenderer.isRenderingPerspective()) {
                    DynamicBufferManger dynamicBufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
                    if (dynamicBufferManger.isEnabled()) {
                        FramebufferStack.push(name);
                        dynamicBufferManger.setupRenderState(name, targetSupplier.get(), true);
                    }
                }
            }
        }, () -> {
            if (!Veil.platform().hasErrors() && !VeilLevelPerspectiveRenderer.isRenderingPerspective() && VeilRenderSystem.renderer().getDynamicBufferManger().isEnabled()) {
                FramebufferStack.pop(name);
            }
        });
    }
}
