package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import imgui.ImGui;
import imgui.flag.ImGuiDataType;
import imgui.flag.ImGuiHoveredFlags;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4617;
import net.minecraft.class_5321;

public class LightInspector extends SingleWindowInspector {

    public static final class_2561 TITLE = class_2561.method_43471("inspector.veil.light.title");

    private static final class_2561 ADD = class_2561.method_43471("inspector.veil.light.button.add");
    private static final class_2561 REMOVE = class_2561.method_43471("inspector.veil.light.button.remove");
    private static final class_2561 REMOVE_ALL = class_2561.method_43471("inspector.veil.light.button.remove_all");
    private static final class_2561 REMOVE_ALL_DESC = class_2561.method_43471("inspector.veil.light.button.remove_all.desc");
    private static final class_2561 SET_POSITION = class_2561.method_43471("inspector.veil.light.button.set_position");
    private static final class_2561 ATTRIBUTES = class_2561.method_43471("inspector.veil.light.attributes");
    private static final class_2561 ENABLE_AO = class_2561.method_43471("inspector.veil.light.toggle.ao");

    private final List<class_5321<LightTypeRegistry.LightType<?>>> lightTypes = new ArrayList<>();
    private class_5321<LightTypeRegistry.LightType<?>> selectedTab;

    private final ImBoolean enableAmbientOcclusion = new ImBoolean();

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public @Nullable class_2561 getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return class_310.method_1551().field_1687 != null && LightTypeRegistry.REGISTRY.method_10204() > 0;
    }

    @Override
    protected void renderComponents() {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();

        if (this.selectedTab == null || !LightTypeRegistry.REGISTRY.method_35842(this.selectedTab)) {
            this.selectedTab = this.lightTypes.getFirst();
        }

        LightTypeRegistry.LightType<?> lightType = LightTypeRegistry.REGISTRY.method_29107(this.selectedTab);
        ImGui.beginDisabled(lightType == null || lightType.debugLightFactory() == null);
        if (ImGui.button(ADD.getString()) && lightType != null && lightType.debugLightFactory() != null) {
            LightTypeRegistry.DebugLightFactory factory = lightType.debugLightFactory();
            class_310 client = class_310.method_1551();
            class_4184 mainCamera = client.field_1773.method_19418();
            lightRenderer.addLight(factory.createDebugLight(client.field_1687, mainCamera));
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered(ImGuiHoveredFlags.None)) {
            VeilImGuiUtil.setTooltip(class_2561.method_43469("inspector.veil.light.button.add.desc", this.selectedTab.method_29177().toString()));
        }

        ImGui.sameLine();
        ImGui.beginDisabled(lightType == null);
        if (ImGui.button(REMOVE.getString()) && lightType != null) {
            for (Light light : lightRenderer.getLights(lightType)) {
                lightRenderer.removeLight(light);
            }
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered(ImGuiHoveredFlags.None)) {
            VeilImGuiUtil.setTooltip(class_2561.method_43469("inspector.veil.light.button.remove.desc", this.selectedTab.method_29177().toString()));
        }

        ImGui.sameLine();
        if (ImGui.button(REMOVE_ALL.getString())) {
            lightRenderer.free();
        }
        if (ImGui.isItemHovered(ImGuiHoveredFlags.None)) {
            VeilImGuiUtil.setTooltip(REMOVE_ALL_DESC);
        }

        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox(ENABLE_AO.getString(), this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }

        ImGui.beginTabBar("##lights");
        for (class_5321<LightTypeRegistry.LightType<?>> key : this.lightTypes) {
            class_2960 id = key.method_29177();
            if (ImGui.beginTabItem(id.toString())) {
                this.selectedTab = key;
                List<Light> lights = lightRenderer.getLights(LightTypeRegistry.REGISTRY.method_29107(key));
                for (int i = 0; i < lights.size(); i++) {
                    ImGui.pushID("light" + i);
                    renderLightComponents(lights.get(i));
                    ImGui.popID();
                }
                ImGui.endTabItem();
            }
        }
        ImGui.endTabBar();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.lightTypes.clear();
        this.lightTypes.addAll(LightTypeRegistry.REGISTRY.method_42021().stream().sorted(Comparator.comparing(class_5321::method_29177)).toList());
    }

    private static void renderLightComponents(Light light) {
        ImBoolean visible = new ImBoolean(true);
        ImGui.pushID(light.hashCode());
        if (ImGui.collapsingHeader(class_4617.method_23267(new UUID(light.hashCode(), 0L)), visible)) {
            renderLightAttributeComponents(light);
        }
        ImGui.popID();
        if (!visible.get()) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light) {
        Vector3fc lightColor = light.getColor();

        float[] editBrightness = new float[]{light.getBrightness()};
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};

        ImGui.indent();
        if (ImGui.dragScalar("brightness", editBrightness, 0.02F)) {
            light.setBrightness(editBrightness[0]);
        }
        if (ImGui.colorEdit3("color", editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }

        if (ImGui.button(SET_POSITION.getString())) {
            light.setTo(class_310.method_1551().field_1773.method_19418());
        }

        ImGui.newLine();
        VeilImGuiUtil.component(ATTRIBUTES);

        if (light instanceof EditorAttributeProvider editorAttributeProvider) {
            editorAttributeProvider.renderImGuiAttributes();
        }
        ImGui.unindent();
    }
}
