package foundry.veil.api.resource.type;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.impl.resource.action.ModelInspectAction;
import foundry.veil.impl.resource.action.TextEditAction;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1092;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public record BlockModelResource(VeilResourceInfo resourceInfo) implements VeilTextResource<BlockModelResource> {

    @Override
    public List<VeilResourceAction<BlockModelResource>> getActions() {
        return List.of(new TextEditAction<>(), new ModelInspectAction<>());
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) throws IOException {
        class_2960 location = this.resourceInfo.location();
        class_3300 resources = resourceManager.resources(this.resourceInfo);
        class_310 client = class_310.method_1551();
        class_1092 modelManager = client.method_1554();
        class_3695 profiler = client.method_16011();

        // TODO: Potentially look at more targeted model reload?
        modelManager.method_25931(CompletableFuture::completedFuture, resources, profiler, profiler, class_156.method_18349(), client)
                .thenAcceptAsync(unused -> VeilRenderSystem.rebuildChunks(), client)
                .exceptionally(e -> {
                    while (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    Veil.LOGGER.error("Failed to load model {}", location, e);
                    return null;
                });
    }

    @Override
    public int getIconCode() {
        return 0xF383;
    }

    @Override
    public @Nullable TextEditorLanguageDefinition languageDefinition() {
        return null;
    }
}
