package foundry.veil.api.event;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.Map;
import net.minecraft.class_2960;

/**
 * Fired when Veil has finished compiling shaders.
 *
 * @author Ocelot
 */
@FunctionalInterface
public interface VeilShaderCompileEvent {

    /**
     * Called when Veil shaders recompile.
     *
     * @param shaderManager   The shader manager instance
     * @param updatedPrograms A view of the programs that have changed
     */
    void onVeilCompileShaders(ShaderManager shaderManager, Map<class_2960, ShaderProgram> updatedPrograms);
}
