package foundry.veil.api.client.render.shader.processor;

import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2960;

/**
 * Processes a shader to add imports.
 *
 * @author Ocelot
 */
public class ShaderImportProcessor implements ShaderPreProcessor {

    private static final String INCLUDE_KEY = "#include ";

    @Override
    public void modify(Context ctx, GlslTree tree) throws IOException, GlslSyntaxException, LexerException {
        List<String> imports = new ArrayList<>();
        List<String> directives = tree.getDirectives();
        for (String directive : directives) {
            if (directive.startsWith(ShaderImportProcessor.INCLUDE_KEY)) {
                imports.add(directive);
            }
        }
        for (String directive : imports) {
            String importId = directive.substring(ShaderImportProcessor.INCLUDE_KEY.length()).trim();
            try {
                ctx.include(tree, class_2960.method_60654(importId), IncludeOverloadStrategy.SOURCE);
            } catch (class_151 e) {
                throw new IOException("Invalid import: " + importId, e);
            }
        }
        directives.removeAll(imports);
    }
}
