/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.render.rendertype.layer.CompositeRenderTypeData;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicRenderTypeManager
extends SimplePreparableReloadListener<Map<ResourceLocation, byte[]>> {
    private static final FileToIdConverter CONVERTER = FileToIdConverter.json((String)"pinwheel/rendertypes");
    private final Map<ResourceLocation, RenderTypeCache> renderTypes = new Object2ObjectArrayMap();

    @Nullable
    public RenderType get(ResourceLocation id, Object ... params) {
        RenderTypeCache cache = this.renderTypes.get(id);
        if (cache == null) {
            return null;
        }
        return cache.get(params);
    }

    @NotNull
    protected Map<ResourceLocation, byte[]> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, byte[]> data = new HashMap<ResourceLocation, byte[]>();
        Map resources = CONVERTER.listMatchingResources(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation id = CONVERTER.fileToId(location);
            try {
                InputStream stream = ((Resource)entry.getValue()).open();
                try {
                    data.put(id, stream.readAllBytes());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't read data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }

    protected void apply(Map<ResourceLocation, byte[]> fileData, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, RenderTypeCache> renderTypes = new HashMap<ResourceLocation, RenderTypeCache>();
        for (Map.Entry<ResourceLocation, byte[]> entry : fileData.entrySet()) {
            ResourceLocation id = entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(entry.getValue()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                DataResult result = CompositeRenderTypeData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(((DataResult.Error)result.error().get()).message());
                }
                CompositeRenderTypeData data = (CompositeRenderTypeData)result.result().orElseThrow();
                if (renderTypes.put(id, new RenderTypeCache(id.toString(), data)) == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, CONVERTER.idToFile(id), e});
            }
        }
        this.renderTypes.clear();
        this.renderTypes.putAll(renderTypes);
        Veil.LOGGER.info("Loaded {} render types", (Object)renderTypes.size());
    }

    private static class RenderTypeCache {
        private final String name;
        private final CompositeRenderTypeData data;
        private final Int2ObjectMap<RenderType> objectCache;
        private RenderType defaultCache;
        private boolean defaultError;

        public RenderTypeCache(String name, CompositeRenderTypeData data) {
            this.name = name;
            this.data = data;
            this.objectCache = new Int2ObjectArrayMap();
            this.defaultCache = null;
        }

        @Nullable
        public RenderType get(Object ... params) {
            if (params.length == 0) {
                if (this.defaultError) {
                    return null;
                }
                if (this.defaultCache == null) {
                    try {
                        this.defaultCache = this.data.createRenderType(this.name, new Object[0]);
                    }
                    catch (Exception e) {
                        Veil.LOGGER.error("Failed to create rendertype {} with no parameters", (Object)this.name, (Object)e);
                        this.defaultError = true;
                    }
                }
                return this.defaultCache;
            }
            return (RenderType)this.objectCache.computeIfAbsent(Arrays.hashCode(params), i -> {
                try {
                    return this.data.createRenderType(this.name, params);
                }
                catch (Exception e) {
                    Veil.LOGGER.error("Failed to create rendertype {} with parameters: [{}]", new Object[]{this.name, Arrays.stream(params).map(Objects::toString).collect(Collectors.joining(", ")), e});
                    return null;
                }
            });
        }
    }
}

