/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.expression;

import com.google.common.collect.Streams;
import foundry.veil.impl.glsl.node.GlslNode;
import java.util.stream.Stream;

public class GlslCompareNode
implements GlslNode {
    private GlslNode first;
    private GlslNode second;
    private Operand operand;

    public GlslCompareNode(GlslNode first, GlslNode second, Operand operand) {
        this.first = first;
        this.second = second;
        this.operand = operand;
    }

    @Override
    public String getSourceString() {
        return this.first.getSourceString() + " " + this.operand.getDelimiter() + " " + this.second.getSourceString();
    }

    @Override
    public Stream<GlslNode> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.first.stream(), this.second.stream()});
    }

    public GlslNode getFirst() {
        return this.first;
    }

    public GlslNode getSecond() {
        return this.second;
    }

    public Operand getOperand() {
        return this.operand;
    }

    public GlslCompareNode setFirst(GlslNode first) {
        this.first = first;
        return this;
    }

    public GlslCompareNode setSecond(GlslNode second) {
        this.second = second;
        return this;
    }

    public GlslCompareNode setOperand(Operand operand) {
        this.operand = operand;
        return this;
    }

    public String toString() {
        return "GlslCompareNode{first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", operand=" + String.valueOf((Object)this.operand) + "}";
    }

    public static enum Operand {
        EQUAL("=="),
        NOT_EQUAL("!="),
        LESS("<"),
        GREATER(">"),
        LEQUAL("<="),
        GEQUAL(">=");

        private final String delimiter;

        private Operand(String delimiter) {
            this.delimiter = delimiter;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

